/*
 * Decompiled with CFR 0.152.
 */
package wsdde.generator;

import java.util.HashMap;
import org.w3c.dom.Element;
import wsdde.corpus.ContextInfo;
import wsdde.corpus.KWIC;
import wsdde.corpus.POSInfo;
import wsdde.corpus.WSDCorpus;
import wsdde.generator.FeatureGenerator;

public class KFG
extends FeatureGenerator {
    public KFG(Element featureGeneratorElement) {
        super(featureGeneratorElement);
    }

    public KFG(HashMap<String, String> parameters) {
        super(parameters);
    }

    public KFG() {
    }

    public static String description() {
        return "KFG - about target keyword";
    }

    @Override
    public void generate(WSDCorpus contexts) {
        for (KWIC kwic : contexts) {
            POSInfo posinfo;
            ContextInfo info = kwic.getInfo("words", 0);
            if (info != null) {
                this.feature(contexts, kwic, info.toString());
            }
            if ((posinfo = (POSInfo)kwic.getInfo("posinfos", 0)) == null) continue;
            int i = 0;
            while (i < posinfo.gramCatNumber()) {
                this.feature(contexts, kwic, posinfo.gramCat(i));
                ++i;
            }
            this.feature(contexts, kwic, posinfo.getGrammClass());
        }
    }

    @Override
    public String id() {
        return "KFG";
    }

    @Override
    public HashMap<String, String> changeParam() {
        return this.parameters;
    }

    @Override
    public void prepareParams() {
    }
}

