/*
 * Decompiled with CFR 0.152.
 */
package wsdde.generator;

import java.util.HashMap;
import java.util.Random;
import org.w3c.dom.Element;
import wsdde.corpus.KWIC;
import wsdde.corpus.POSInfo;
import wsdde.corpus.WSDCorpus;
import wsdde.generator.FeatureGenerator;

public class SFG2
extends FeatureGenerator {
    int windowSize;
    int simple_gram_class;
    int gram_cat_values;

    public SFG2(Element featureGeneratorElement) {
        super(featureGeneratorElement);
    }

    public SFG2(HashMap<String, String> parameters) {
        super(parameters);
    }

    public SFG2() {
    }

    @Override
    public void prepareParams() {
        this.windowSize = Integer.parseInt(this.getParam("window_size"));
        this.simple_gram_class = Integer.parseInt(this.getParam("simple_gram_class"));
        this.gram_cat_values = Integer.parseInt(this.getParam("gram_cat_values"));
    }

    public static String description() {
        return "SFG2 based on POS";
    }

    @Override
    public void generate(WSDCorpus contexts) {
        for (KWIC kwic : contexts) {
            int i = -this.windowSize;
            while (i <= this.windowSize) {
                POSInfo posinfo;
                if (i != 0 && (posinfo = (POSInfo)kwic.getInfo("posinfos", i)) != null) {
                    if (this.simple_gram_class == 1) {
                        this.feature(contexts, kwic, String.valueOf(posinfo.getGramClassSimple()) + (i < 0 ? "" : "+") + i);
                    } else {
                        this.feature(contexts, kwic, String.valueOf(posinfo.getGrammClass()) + (i < 0 ? "" : "+") + i);
                    }
                    if (this.gram_cat_values == 1) {
                        int j = 0;
                        while (j < posinfo.gramCatNumber()) {
                            this.feature(contexts, kwic, String.valueOf(posinfo.gramCat(j)) + (i < 0 ? "" : "+") + i);
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public String id() {
        return "SFG2";
    }

    @Override
    public HashMap<String, String> changeParam() {
        HashMap<String, String> hm = new HashMap<String, String>(this.parameters);
        if (Math.random() < 0.3) {
            hm.put("simple_gram_class", String.valueOf(1 - this.simple_gram_class));
        } else if (Math.random() < 0.5) {
            Random r = new Random();
            hm.put("window_size", String.valueOf(Math.abs(this.windowSize + r.nextInt(4) - 2)));
        } else {
            hm.put("gram_cat_values", String.valueOf(1 - this.gram_cat_values));
        }
        return hm;
    }
}

