/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.JFrame;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.converters.ArffSaver;
import weka.core.converters.DatabaseConverter;
import weka.core.converters.DatabaseSaver;
import weka.gui.beans.AbstractDataSink;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSink;
import weka.gui.beans.InstanceEvent;
import weka.gui.beans.KnowledgeFlowApp;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.WekaWrapper;

public class Saver
extends AbstractDataSink
implements WekaWrapper,
EnvironmentHandler {
    private static final long serialVersionUID = 5371716690308950755L;
    private Instances m_dataSet;
    private Instances m_structure;
    protected String m_globalInfo;
    private transient SaveBatchThread m_ioThread;
    private weka.core.converters.Saver m_Saver = new ArffSaver();
    private String m_fileName;
    private boolean m_isDBSaver;
    private boolean m_relationNameForFilename = true;
    private int m_count;
    protected transient Environment m_env;

    private synchronized void block(boolean bl) {
        if (bl) {
            try {
                if (this.m_ioThread.isAlive()) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.notifyAll();
        }
    }

    public boolean isBusy() {
        return this.m_ioThread != null;
    }

    public String globalInfo() {
        return this.m_globalInfo;
    }

    public Saver() {
        this.setSaver(this.m_Saver);
        this.m_fileName = "";
        this.m_dataSet = null;
        this.m_count = 0;
    }

    public void setCustomName(String string) {
        this.m_visual.setText(string);
    }

    public String getCustomName() {
        return this.m_visual.getText();
    }

    public void setEnvironment(Environment environment) {
        this.m_env = environment;
    }

    private void passEnvOnToSaver() {
        if (this.m_Saver instanceof EnvironmentHandler && this.m_env != null) {
            ((EnvironmentHandler)((Object)this.m_Saver)).setEnvironment(this.m_env);
        }
    }

    public void setSaver(weka.core.converters.Saver saver) {
        boolean bl = true;
        if (saver.getClass().getName().compareTo(this.m_Saver.getClass().getName()) == 0) {
            bl = false;
        }
        this.m_Saver = saver;
        String string = saver.getClass().toString();
        string = string.substring(string.lastIndexOf(46) + 1, string.length());
        if (bl && !this.m_visual.loadIcons("weka/gui/beans/icons/" + string + ".gif", "weka/gui/beans/icons/" + string + "_animated.gif")) {
            this.useDefaultVisual();
        }
        this.m_visual.setText(string);
        this.m_globalInfo = KnowledgeFlowApp.getGlobalInfo(this.m_Saver);
        this.m_isDBSaver = this.m_Saver instanceof DatabaseConverter;
    }

    protected String sanitizeFilename(String string) {
        string = string.replaceAll("\\\\", "_").replaceAll(":", "_").replaceAll("/", "_");
        string = Utils.removeSubstring(string, "weka.filters.supervised.instance.");
        string = Utils.removeSubstring(string, "weka.filters.supervised.attribute.");
        string = Utils.removeSubstring(string, "weka.filters.unsupervised.instance.");
        string = Utils.removeSubstring(string, "weka.filters.unsupervised.attribute.");
        string = Utils.removeSubstring(string, "weka.clusterers.");
        string = Utils.removeSubstring(string, "weka.associations.");
        string = Utils.removeSubstring(string, "weka.attributeSelection.");
        string = Utils.removeSubstring(string, "weka.estimators.");
        string = Utils.removeSubstring(string, "weka.datagenerators.");
        if (!this.m_isDBSaver && !this.m_relationNameForFilename) {
            string = "";
            try {
                if (this.m_Saver.filePrefix().equals("")) {
                    this.m_Saver.setFilePrefix("no-name");
                }
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        return string;
    }

    public synchronized void acceptDataSet(DataSetEvent dataSetEvent) {
        this.passEnvOnToSaver();
        this.m_fileName = this.sanitizeFilename(dataSetEvent.getDataSet().relationName());
        this.m_dataSet = dataSetEvent.getDataSet();
        if (dataSetEvent.isStructureOnly() && this.m_isDBSaver && ((DatabaseSaver)this.m_Saver).getRelationForTableName()) {
            ((DatabaseSaver)this.m_Saver).setTableName(this.m_fileName);
        }
        if (!dataSetEvent.isStructureOnly()) {
            if (!this.m_isDBSaver) {
                try {
                    this.m_Saver.setDirAndPrefix(this.m_fileName, "");
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            }
            this.saveBatch();
            System.out.println("...relation " + this.m_fileName + " saved.");
        }
    }

    public synchronized void acceptTestSet(TestSetEvent testSetEvent) {
        this.passEnvOnToSaver();
        this.m_fileName = this.sanitizeFilename(testSetEvent.getTestSet().relationName());
        this.m_dataSet = testSetEvent.getTestSet();
        if (testSetEvent.isStructureOnly() && this.m_isDBSaver && ((DatabaseSaver)this.m_Saver).getRelationForTableName()) {
            ((DatabaseSaver)this.m_Saver).setTableName(this.m_fileName);
        }
        if (!testSetEvent.isStructureOnly()) {
            if (!this.m_isDBSaver) {
                try {
                    this.m_Saver.setDirAndPrefix(this.m_fileName, "_test_" + testSetEvent.getSetNumber() + "_of_" + testSetEvent.getMaxSetNumber());
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            } else {
                String string = ((DatabaseSaver)this.m_Saver).getTableName();
                string = string.replaceFirst("_[tT][eE][sS][tT]_[0-9]+_[oO][fF]_[0-9]+", "");
                ((DatabaseSaver)this.m_Saver).setTableName(string + "_test_" + testSetEvent.getSetNumber() + "_of_" + testSetEvent.getMaxSetNumber());
            }
            this.saveBatch();
            System.out.println("... test set " + testSetEvent.getSetNumber() + " of " + testSetEvent.getMaxSetNumber() + " for relation " + this.m_fileName + " saved.");
        }
    }

    public synchronized void acceptTrainingSet(TrainingSetEvent trainingSetEvent) {
        this.passEnvOnToSaver();
        this.m_fileName = this.sanitizeFilename(trainingSetEvent.getTrainingSet().relationName());
        this.m_dataSet = trainingSetEvent.getTrainingSet();
        if (trainingSetEvent.isStructureOnly() && this.m_isDBSaver && ((DatabaseSaver)this.m_Saver).getRelationForTableName()) {
            ((DatabaseSaver)this.m_Saver).setTableName(this.m_fileName);
        }
        if (!trainingSetEvent.isStructureOnly()) {
            if (!this.m_isDBSaver) {
                try {
                    this.m_Saver.setDirAndPrefix(this.m_fileName, "_training_" + trainingSetEvent.getSetNumber() + "_of_" + trainingSetEvent.getMaxSetNumber());
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            } else {
                String string = ((DatabaseSaver)this.m_Saver).getTableName();
                string = string.replaceFirst("_[tT][rR][aA][iI][nN][iI][nN][gG]_[0-9]+_[oO][fF]_[0-9]+", "");
                ((DatabaseSaver)this.m_Saver).setTableName(string + "_training_" + trainingSetEvent.getSetNumber() + "_of_" + trainingSetEvent.getMaxSetNumber());
            }
            this.saveBatch();
            System.out.println("... training set " + trainingSetEvent.getSetNumber() + " of " + trainingSetEvent.getMaxSetNumber() + " for relation " + this.m_fileName + " saved.");
        }
    }

    public synchronized void saveBatch() {
        this.m_Saver.setRetrieval(1);
        this.m_ioThread = new SaveBatchThread(this);
        this.m_ioThread.setPriority(1);
        this.m_ioThread.start();
        this.block(true);
    }

    public synchronized void acceptInstance(InstanceEvent instanceEvent) {
        if (instanceEvent.getStatus() == 0) {
            this.m_Saver.setRetrieval(2);
            this.m_structure = instanceEvent.getStructure();
            this.m_fileName = this.sanitizeFilename(this.m_structure.relationName());
            this.m_Saver.setInstances(this.m_structure);
            if (this.m_isDBSaver && ((DatabaseSaver)this.m_Saver).getRelationForTableName()) {
                ((DatabaseSaver)this.m_Saver).setTableName(this.m_fileName);
            }
        }
        if (instanceEvent.getStatus() == 1) {
            this.m_visual.setAnimated();
            if (this.m_count == 0) {
                this.passEnvOnToSaver();
                if (!this.m_isDBSaver) {
                    try {
                        this.m_Saver.setDirAndPrefix(this.m_fileName, "");
                    }
                    catch (Exception exception) {
                        System.out.println(exception);
                        this.m_visual.setStatic();
                    }
                }
                ++this.m_count;
            }
            try {
                this.m_Saver.writeIncremental(instanceEvent.getInstance());
            }
            catch (Exception exception) {
                this.m_visual.setStatic();
                System.err.println("Instance " + instanceEvent.getInstance() + " could not been saved");
                exception.printStackTrace();
            }
        }
        if (instanceEvent.getStatus() == 2) {
            try {
                this.m_Saver.writeIncremental(instanceEvent.getInstance());
                this.m_Saver.writeIncremental(null);
                this.m_visual.setStatic();
                System.out.println("...relation " + this.m_fileName + " saved.");
                this.m_count = 0;
            }
            catch (Exception exception) {
                this.m_visual.setStatic();
                System.err.println("File could not have been closed.");
                exception.printStackTrace();
            }
        }
    }

    public weka.core.converters.Saver getSaver() {
        return this.m_Saver;
    }

    public void setWrappedAlgorithm(Object object) {
        if (!(object instanceof weka.core.converters.Saver)) {
            throw new IllegalArgumentException(object.getClass() + " : incorrect " + "type of algorithm (Loader)");
        }
        this.setSaver((weka.core.converters.Saver)object);
    }

    public Object getWrappedAlgorithm() {
        return this.getSaver();
    }

    public void setRelationNameForFilename(boolean bl) {
        this.m_relationNameForFilename = bl;
    }

    public boolean getRelationNameForFilename() {
        return this.m_relationNameForFilename;
    }

    public void stop() {
        if (this.m_listenee instanceof BeanCommon) {
            ((BeanCommon)this.m_listenee).stop();
        }
        if (this.m_ioThread != null) {
            this.m_ioThread.interrupt();
            this.m_ioThread.stop();
            this.m_ioThread = null;
            this.m_visual.setStatic();
        }
    }

    private String statusMessagePrefix() {
        return this.getCustomName() + "$" + this.hashCode() + "|" + (this.m_Saver instanceof OptionHandler ? Utils.joinOptions(((OptionHandler)((Object)this.m_Saver)).getOptions()) + "|" : "");
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.m_env = Environment.getSystemWide();
    }

    public static void main(String[] stringArray) {
        try {
            final JFrame jFrame = new JFrame();
            jFrame.getContentPane().setLayout(new BorderLayout());
            Saver saver = new Saver();
            jFrame.getContentPane().add((Component)saver, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.setSize(800, 600);
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class SaveBatchThread
    extends Thread {
        private DataSink m_DS;

        public SaveBatchThread(DataSink dataSink) {
            this.m_DS = dataSink;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block13: {
                try {
                    try {
                        Saver.this.m_visual.setAnimated();
                        Saver.this.m_Saver.setInstances(Saver.this.m_dataSet);
                        if (Saver.this.m_logger != null) {
                            Saver.this.m_logger.statusMessage(Saver.this.statusMessagePrefix() + "Saving " + Saver.this.m_dataSet.relationName() + "...");
                        }
                        Saver.this.m_Saver.writeBatch();
                        if (Saver.this.m_logger != null) {
                            Saver.this.m_logger.logMessage("[Saver] " + Saver.this.statusMessagePrefix() + "Save successful.");
                        }
                    }
                    catch (Exception exception) {
                        if (Saver.this.m_logger != null) {
                            Saver.this.m_logger.statusMessage(Saver.this.statusMessagePrefix() + "ERROR (See log for details)");
                            Saver.this.m_logger.logMessage("[Saver] " + Saver.this.statusMessagePrefix() + " problem saving. " + exception.getMessage());
                        }
                        exception.printStackTrace();
                        Object var3_2 = null;
                        if (Thread.currentThread().isInterrupted() && Saver.this.m_logger != null) {
                            Saver.this.m_logger.logMessage("[Saver] " + Saver.this.statusMessagePrefix() + " Saving interrupted!!");
                        }
                        if (Saver.this.m_logger != null) {
                            Saver.this.m_logger.statusMessage(Saver.this.statusMessagePrefix() + "Finished.");
                        }
                        Saver.this.block(false);
                        Saver.this.m_visual.setStatic();
                        Saver.this.m_ioThread = null;
                        return;
                    }
                    Object var3_1 = null;
                    if (Thread.currentThread().isInterrupted() && Saver.this.m_logger != null) {
                        Saver.this.m_logger.logMessage("[Saver] " + Saver.this.statusMessagePrefix() + " Saving interrupted!!");
                    }
                    if (Saver.this.m_logger == null) break block13;
                    Saver.this.m_logger.statusMessage(Saver.this.statusMessagePrefix() + "Finished.");
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    if (Thread.currentThread().isInterrupted() && Saver.this.m_logger != null) {
                        Saver.this.m_logger.logMessage("[Saver] " + Saver.this.statusMessagePrefix() + " Saving interrupted!!");
                    }
                    if (Saver.this.m_logger != null) {
                        Saver.this.m_logger.statusMessage(Saver.this.statusMessagePrefix() + "Finished.");
                    }
                    Saver.this.block(false);
                    Saver.this.m_visual.setStatic();
                    Saver.this.m_ioThread = null;
                    throw throwable;
                }
            }
            Saver.this.block(false);
            Saver.this.m_visual.setStatic();
            Saver.this.m_ioThread = null;
        }
    }
}

