/*
 * Decompiled with CFR 0.152.
 */
package ipipan.poliqarp.gui;

import ipipan.poliqarp.connection.PoliqarpConnection;
import ipipan.poliqarp.logic.IConfiguration;
import ipipan.poliqarp.util.MRUCollection;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration
implements Cloneable,
IConfiguration {
    private Map<String, String> config = new HashMap<String, String>();
    private MRUCollection<String> mru = new MRUCollection();
    private Locale currentLocale;
    private ResourceBundle currentBundle = null;
    public static final String OPT_LC = "left-context";
    public static final String OPT_RC = "right-context";
    public static final String OPT_WC = "wide-context";
    public static final String OPT_SORTBY = "sort-by";
    public static final String OPT_DISPORTH = "display-orth";
    public static final String OPT_DISPBASE = "display-base";
    public static final String OPT_DISPTAG = "display-tag";
    public static final String OPT_DISPORTHCONTEXT = "display-orth-context";
    public static final String OPT_DISPBASECONTEXT = "display-base-context";
    public static final String OPT_DISPTAGCONTEXT = "display-tag-context";
    public static final String OPT_DISPDISAMB = "display-disambiguated-tags";
    public static final String OPT_QUERYI = "query-i";
    public static final String OPT_QUERYX = "query-x";
    public static final String OPT_METAI = "meta-i";
    public static final String OPT_METAX = "meta-x";
    public static final String OPT_BOLD = "bold-lemmas";
    public static final String OPT_FONTSIZE = "gui-font-size";
    public static final String OPT_SERVER = "server";
    public static final String OPT_PORT = "port";

    public Configuration() {
    }

    public Configuration(String string) throws FileNotFoundException, IOException {
        this();
        FileReader fileReader = new FileReader(string);
        StreamTokenizer streamTokenizer = new StreamTokenizer(fileReader);
        streamTokenizer.resetSyntax();
        streamTokenizer.eolIsSignificant(false);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.wordChars(33, 1024);
        streamTokenizer.quoteChar(34);
        int n = -3;
        while (true) {
            n = streamTokenizer.nextToken();
            if (n == -1) break;
            if (n != -3) continue;
            String string2 = streamTokenizer.sval;
            if (string2.equals("set")) {
                n = streamTokenizer.nextToken();
                if (n != -3 && n != 34) {
                    System.err.println("Warning: Incorrect token detected: " + n);
                    break;
                }
                String string3 = streamTokenizer.sval;
                n = streamTokenizer.nextToken();
                if (n != -3 && n != 34) {
                    System.err.println("Warning: Incorrect token detected: " + n);
                    break;
                }
                String string4 = streamTokenizer.sval;
                this.addConfigItem(string3, string4);
                continue;
            }
            System.err.println("Warning: Incorrect command: " + string2);
        }
        try {
            this.setLanguage(this.getConfigItem("language"));
        }
        catch (NoSuchElementException noSuchElementException) {
            this.setLanguage("English");
        }
        fileReader.close();
        this.setMissingToDefault();
        this.makeMRU();
    }

    public void setDefault(String string, String string2) {
        try {
            this.getConfigItem(string);
        }
        catch (NoSuchElementException noSuchElementException) {
            this.addConfigItem(string, string2);
        }
    }

    public void setMissingToDefault() {
        this.setDefault(OPT_LC, "5");
        this.setDefault(OPT_RC, "5");
        this.setDefault(OPT_WC, "50");
        this.setDefault(OPT_DISPORTH, "yes");
        this.setDefault(OPT_DISPORTHCONTEXT, "yes");
        this.setDefault(OPT_DISPBASE, "yes");
        this.setDefault(OPT_DISPBASECONTEXT, "no");
        this.setDefault(OPT_DISPTAG, "yes");
        this.setDefault(OPT_DISPTAGCONTEXT, "no");
        this.setDefault(OPT_DISPDISAMB, "yes");
        this.setDefault(OPT_QUERYI, "no");
        this.setDefault(OPT_QUERYX, "no");
        this.setDefault(OPT_METAI, "yes");
        this.setDefault(OPT_METAX, "yes");
        this.setDefault(OPT_SORTBY, "");
        this.setDefault(OPT_SERVER, "127.0.0.1");
        this.setDefault(OPT_PORT, "4567");
        this.setDefault(OPT_FONTSIZE, "11");
    }

    private void makeMRU() {
        this.mru = new MRUCollection();
        for (int i = 9; i >= 0; --i) {
            try {
                this.mru.add(this.getConfigItem("mru_" + i));
                continue;
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    public MRUCollection<String> getMRU() {
        return this.mru;
    }

    public String getMenuComponentName(int n) {
        return this.getComponentName("MENU_" + n);
    }

    public String getComponentName(String string) {
        return this.currentBundle.getString(string);
    }

    public void addConfigItem(String string, String string2) {
        this.config.put(string, string2);
    }

    @Override
    public String getConfigItem(String string) throws NoSuchElementException {
        String string2 = this.config.get(string);
        if (string2 == null) {
            throw new NoSuchElementException();
        }
        return string2;
    }

    public int getConfigItemNum(String string) throws NoSuchElementException {
        int n = 0;
        try {
            n = Integer.parseInt(this.getConfigItem(string));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public void setLanguage(String string) {
        this.addConfigItem("language", string);
        String string2 = string.toLowerCase().equals("english") ? "en" : (string.toLowerCase().equals("polish") ? "pl" : "en");
        this.currentLocale = new Locale(string2);
        Locale.setDefault(this.currentLocale);
        try {
            UIManager.setLookAndFeel(UIManager.getLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            // empty catch block
        }
        this.currentBundle = ResourceBundle.getBundle("poliqarp", this.currentLocale);
    }

    public void writeConfig(String string) throws IOException {
        this.updateMRU();
        FileWriter fileWriter = new FileWriter(string);
        for (Map.Entry<String, String> entry : this.config.entrySet()) {
            String string2 = entry.getKey();
            String string3 = entry.getValue();
            string3 = string3.replaceAll("\"", "\\\\\"");
            string3 = string3.replaceAll("\n", "\\\\n");
            string3 = string3.replaceAll("\t", "\\\\t");
            string3 = string3.replaceAll("\\\\", "\\\\\\\\");
            fileWriter.write("set " + string2 + " \"" + string3 + "\"\n");
        }
        fileWriter.close();
    }

    private void updateMRU() {
        int n = 0;
        for (String string : this.mru) {
            this.addConfigItem("mru_" + n, string);
            if (++n != 10) continue;
            break;
        }
    }

    public Object clone() {
        Configuration configuration = new Configuration();
        this.copyTo(configuration);
        return configuration;
    }

    public void copyTo(Configuration configuration) {
        configuration.config = new HashMap<String, String>(this.config);
        configuration.currentBundle = this.currentBundle;
        configuration.mru = this.mru;
    }

    public Locale getCurrentLocale() {
        return this.currentLocale;
    }

    private void safeSet(PoliqarpConnection poliqarpConnection, String string) throws Exception {
        poliqarpConnection.send("SET " + string);
        if (!poliqarpConnection.getMessage().isOK()) {
            throw new Exception();
        }
    }

    public void updateConfig(PoliqarpConnection poliqarpConnection) {
        try {
            this.safeSet(poliqarpConnection, "left-context-width " + this.getConfigItem(OPT_LC));
            this.safeSet(poliqarpConnection, "right-context-width " + this.getConfigItem(OPT_RC));
            this.safeSet(poliqarpConnection, "wide-context-width " + this.getConfigItem(OPT_WC));
            this.safeSet(poliqarpConnection, "retrieve-lemmata 1111");
            this.safeSet(poliqarpConnection, "retrieve-tags 1111");
            boolean bl = this.getConfigItem(OPT_DISPDISAMB).equals("yes");
            boolean bl2 = this.getConfigItem(OPT_QUERYI).equals("yes");
            boolean bl3 = this.getConfigItem(OPT_QUERYX).equals("yes");
            boolean bl4 = this.getConfigItem(OPT_METAI).equals("yes");
            boolean bl5 = this.getConfigItem(OPT_METAX).equals("yes");
            poliqarpConnection.getOptions().setQueryFlags(bl2, bl3, bl4, bl5);
            poliqarpConnection.getOptions().setAmbiguationDisplay(bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

