/*
 * Decompiled with CFR 0.152.
 */
package ipipan.poliqarp.gui;

import com.jgoodies.forms.layout.CellConstraints;
import ipipan.poliqarp.gui.DateConstraintModel;
import ipipan.poliqarp.gui.MetaDataConstraint;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;

public class DateConstraint
extends MetaDataConstraint {
    private DateConstraintModel model;
    private boolean from;
    private boolean to;
    private JLabel label;
    private JCheckBox cbFrom;
    private JCheckBox cbTo;
    private JSpinner spFrom;
    private JSpinner spTo;

    public DateConstraint(DateConstraintModel dateConstraintModel) {
        this.model = dateConstraintModel;
        this.from = dateConstraintModel.getFrom();
        this.to = dateConstraintModel.getTo();
        this.label = new JLabel(dateConstraintModel.getName() + ": ");
        this.cbFrom = new JCheckBox("From: ", this.from);
        this.cbTo = new JCheckBox("To: ", this.to);
        SpinnerDateModel spinnerDateModel = new SpinnerDateModel(dateConstraintModel.getDateFrom(), null, null, 1);
        this.spFrom = new JSpinner(spinnerDateModel);
        this.spFrom.setEditor(new JSpinner.DateEditor(this.spFrom, "dd-MM-yyyy"));
        this.spFrom.setEnabled(this.from);
        spinnerDateModel = new SpinnerDateModel(dateConstraintModel.getDateTo(), null, null, 1);
        this.spTo = new JSpinner(spinnerDateModel);
        this.spTo.setEditor(new JSpinner.DateEditor(this.spTo, "dd-MM-yyyy"));
        this.spTo.setEnabled(this.to);
        this.cbFrom.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                DateConstraint.this.from = !DateConstraint.this.from;
                DateConstraint.this.spFrom.setEnabled(DateConstraint.this.from);
            }
        });
        this.cbTo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                DateConstraint.this.to = !DateConstraint.this.to;
                DateConstraint.this.spTo.setEnabled(DateConstraint.this.to);
            }
        });
    }

    public void update() {
        this.model.setFromTo(this.from, this.to);
        this.model.setDateFrom(((SpinnerDateModel)this.spFrom.getModel()).getDate());
        this.model.setDateTo(((SpinnerDateModel)this.spTo.getModel()).getDate());
    }

    public void setWidgets(JPanel jPanel, int n) {
        CellConstraints cellConstraints = new CellConstraints();
        jPanel.add((Component)this.label, cellConstraints.xy(4, n + 1));
        jPanel.add((Component)this.cbFrom, cellConstraints.xy(6, n + 1));
        jPanel.add((Component)this.spFrom, cellConstraints.xy(8, n + 1));
        jPanel.add((Component)this.cbTo, cellConstraints.xy(10, n + 1));
        jPanel.add((Component)this.spTo, cellConstraints.xy(12, n + 1));
    }
}

