/*
 * Decompiled with CFR 0.152.
 */
package ipipan.poliqarp.gui;

import ipipan.poliqarp.gui.Configuration;
import ipipan.poliqarp.gui.MetaDataModel;
import ipipan.poliqarp.gui.MultiColorCellRenderer;
import ipipan.poliqarp.gui.MultilingualEntity;
import ipipan.poliqarp.gui.TableCellSizeAdjustor;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MetaDataTable
extends JTable
implements MultilingualEntity,
ListSelectionListener {
    private MetaDataModel model = new MetaDataModel();
    private MultiColorCellRenderer renderer;

    public MetaDataTable() {
        this.setModel(this.model);
        this.setAutoResizeMode(0);
        this.setCellSelectionEnabled(false);
        this.setRowSelectionAllowed(true);
        Color[] colorArray = new Color[]{new Color(192, 255, 192), new Color(255, 255, 255)};
        this.renderer = new MultiColorCellRenderer(colorArray);
        this.setDefaultRenderer(Object.class, this.renderer);
        TableCellSizeAdjustor.adjustorForTable((JTable)this, 1);
        this.getSelectionModel().addListSelectionListener(this);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int[] nArray = this.getSelectedRows();
        StringBuilder stringBuilder = new StringBuilder();
        for (int n : nArray) {
            stringBuilder.append(this.model.getValueAt(n, 0) + "=>" + this.model.getValueAt(n, 1) + "\n");
        }
        StringSelection stringSelection = new StringSelection(stringBuilder.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
        this.repaint();
    }

    public MetaDataModel getModel() {
        return this.model;
    }

    public void updateLanguage(Configuration configuration) {
        this.model.setColumnNames(configuration);
        this.setDefaultRenderer(String.class, this.renderer);
    }
}

