/*
 * Decompiled with CFR 0.152.
 */
package ipipan.poliqarp.logic;

import ipipan.poliqarp.connection.AsyncHandler;
import ipipan.poliqarp.connection.Message;
import ipipan.poliqarp.connection.PoliqarpConnection;
import ipipan.poliqarp.logic.CorpusNotOpenedException;
import ipipan.poliqarp.logic.CorpusStatistics;
import ipipan.poliqarp.logic.MetaData;
import ipipan.poliqarp.logic.ServerJob;
import ipipan.poliqarp.util.Pair;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Corpus
extends ServerJob
implements AsyncHandler {
    private String name;
    private State state;
    private List<Pair<MetaData.Type, String>> metaTypes = null;

    @Override
    public void handle(String string) {
        if (string.equals("OPENED")) {
            this.state = State.OPENED;
            this.connection.setAsyncHandler(null);
            this.launchNotifier();
        } else if (string.startsWith("OPENFAIL")) {
            this.state = State.NOT_OPENED;
            this.connection.setAsyncHandler(null);
            this.launchNotifier();
        } else {
            System.err.println("Unknown async message: " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Corpus(PoliqarpConnection poliqarpConnection, String string, Runnable runnable) throws CorpusNotOpenedException {
        super(poliqarpConnection);
        this.name = string;
        this.state = State.OPENING;
        this.setNotifier(runnable);
        poliqarpConnection.setAsyncHandler(this);
        try {
            Corpus corpus = this;
            synchronized (corpus) {
                poliqarpConnection.send("OPEN " + string);
                Message message = poliqarpConnection.getMessage();
                if (!message.isOK()) {
                    throw new CorpusNotOpenedException();
                }
            }
        }
        catch (IOException iOException) {
            throw new CorpusNotOpenedException();
        }
    }

    public CorpusStatistics getStatistics() throws CorpusNotOpenedException {
        if (this.state != State.OPENED) {
            throw new CorpusNotOpenedException();
        }
        try {
            this.connection.send("CORPUS-STATS");
            Message message = this.connection.getMessage();
            if (!message.isOK()) {
                throw new CorpusNotOpenedException();
            }
            return new CorpusStatistics(message.getOKIntInfo(0), message.getOKIntInfo(1), message.getOKIntInfo(2), message.getOKIntInfo(3));
        }
        catch (IOException iOException) {
            throw new CorpusNotOpenedException();
        }
    }

    public String getLastError() throws CorpusNotOpenedException {
        try {
            this.connection.send("GET-LAST-ERROR");
            String string = this.connection.getMessage().toString();
            if (string.startsWith("ERROR ")) {
                return string.substring("ERROR ".length());
            }
            return null;
        }
        catch (IOException iOException) {
            throw new CorpusNotOpenedException();
        }
    }

    public List<Pair<MetaData.Type, String>> getMetaTypes() throws CorpusNotOpenedException {
        if (this.metaTypes != null) {
            return this.metaTypes;
        }
        if (this.state != State.OPENED) {
            throw new CorpusNotOpenedException();
        }
        LinkedList<Pair<MetaData.Type, String>> linkedList = new LinkedList<Pair<MetaData.Type, String>>();
        try {
            this.connection.send("METADATA-TYPES");
            Message message = this.connection.getMessage();
            if (!message.isOK()) {
                throw new CorpusNotOpenedException();
            }
            int n = message.getOKIntInfo(0);
            for (int i = 0; i < n; ++i) {
                String string = this.connection.getMessage().toString();
                String string2 = string.substring(2);
                MetaData.Type type = null;
                switch (string.charAt(0)) {
                    case 'T': {
                        type = MetaData.Type.TEXT;
                        break;
                    }
                    case 'D': {
                        type = MetaData.Type.DATE;
                        break;
                    }
                    default: {
                        throw new CorpusNotOpenedException();
                    }
                }
                linkedList.add(new Pair<MetaData.Type, String>(type, string2));
            }
        }
        catch (IOException iOException) {
            throw new CorpusNotOpenedException();
        }
        this.metaTypes = linkedList;
        return linkedList;
    }

    public Map<String, String> getAliases() throws CorpusNotOpenedException {
        if (this.state != State.OPENED) {
            throw new CorpusNotOpenedException();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            this.connection.send("GET-ALIASES");
            Message message = this.connection.getMessage();
            if (!message.isOK()) {
                throw new CorpusNotOpenedException();
            }
            int n = message.getOKIntInfo(0);
            for (int i = 0; i < n; ++i) {
                String string = this.connection.getMessage().toString();
                String string2 = this.connection.getMessage().toString();
                hashMap.put(string, string2);
            }
        }
        catch (IOException iOException) {
            throw new CorpusNotOpenedException();
        }
        return hashMap;
    }

    public void defineAlias(String string, String string2) throws CorpusNotOpenedException {
        if (this.state != State.OPENED) {
            throw new CorpusNotOpenedException();
        }
        try {
            this.connection.send("CREATE-ALIAS " + string + " " + string2);
            Message message = this.connection.getMessage();
            if (!message.isOK()) {
                throw new CorpusNotOpenedException();
            }
        }
        catch (IOException iOException) {
            throw new CorpusNotOpenedException();
        }
    }

    public void deleteAlias(String string) throws CorpusNotOpenedException {
        if (this.state != State.OPENED) {
            throw new CorpusNotOpenedException();
        }
        try {
            this.connection.send("DELETE-ALIAS " + string);
            Message message = this.connection.getMessage();
            if (!message.isOK()) {
                throw new CorpusNotOpenedException();
            }
        }
        catch (IOException iOException) {
            throw new CorpusNotOpenedException();
        }
    }

    public State getState() {
        return this.state;
    }

    public void close() throws CorpusNotOpenedException {
        block4: {
            try {
                if (this.state == State.OPENED) {
                    this.connection.send("CLOSE");
                    Message message = this.connection.getMessage();
                    if (!message.isOK()) {
                        System.err.println(message.toString());
                        throw new CorpusNotOpenedException();
                    }
                    break block4;
                }
                throw new CorpusNotOpenedException();
            }
            catch (Exception exception) {
                throw new CorpusNotOpenedException();
            }
        }
        this.state = State.NOT_OPENED;
    }

    public String getName() {
        return this.name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        OPENING,
        OPENED,
        NOT_OPENED;

    }
}

