/*
 * Decompiled with CFR 0.152.
 */
package ipipan.poliqarp.logic;

import ipipan.poliqarp.connection.PoliqarpConnection;
import ipipan.poliqarp.logic.QueryException;
import java.io.IOException;

public final class WideContext {
    private String leftContext;
    private String leftMatch;
    private String rightMatch;
    private String rightContext;

    WideContext(PoliqarpConnection poliqarpConnection, int n) throws IOException, QueryException {
        poliqarpConnection.send("GET-CONTEXT " + n);
        if (!poliqarpConnection.getMessage().isOK()) {
            throw new QueryException();
        }
        this.leftContext = poliqarpConnection.getMessage().toString();
        this.leftMatch = poliqarpConnection.getMessage().toString();
        this.rightMatch = poliqarpConnection.getMessage().toString();
        this.rightContext = poliqarpConnection.getMessage().toString();
    }

    public String toString() {
        return this.leftContext + this.leftMatch + this.rightMatch + this.rightContext;
    }

    private String htmlize(String string) {
        return string.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    public String toHTML() {
        return this.htmlize(this.leftContext) + "<span style=\"color: #000066; font-weight: bold\">" + this.htmlize(this.leftMatch + this.rightMatch) + "</span>" + this.htmlize(this.rightContext);
    }
}

