/*
 * Decompiled with CFR 0.152.
 */
package ipipan.poliqarp.stat;

import ipipan.poliqarp.stat.CTest;
import ipipan.poliqarp.stat.MatchCount;
import java.text.Collator;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchCountComparator
implements Comparator<MatchCount> {
    static final int AFRONTE = 1;
    static final int ATERGO = 2;
    static final int BY_FREQ = 3;
    static final int CTEST = 4;
    int order = 0;
    CTest ctest = null;
    Collator collator;
    String testName;

    int getOrder(String string) {
        if (string.equalsIgnoreCase("by freq")) {
            return 3;
        }
        if (string.equalsIgnoreCase("a fronte")) {
            return 1;
        }
        if (string.equalsIgnoreCase("a tergo")) {
            return 2;
        }
        if (string.startsWith("by ")) {
            this.testName = string.substring(3);
            this.ctest = new CTest(this.testName);
            return 4;
        }
        return 0;
    }

    public MatchCountComparator(int n) {
        this.order = n;
        this.collator = Collator.getInstance();
    }

    public MatchCountComparator(String string) {
        this.order = this.getOrder(string.trim());
        this.collator = Collator.getInstance();
    }

    @Override
    public int compare(MatchCount matchCount, MatchCount matchCount2) {
        if (matchCount == null && matchCount2 == null) {
            return 0;
        }
        if (matchCount == null) {
            return 1;
        }
        if (matchCount2 == null) {
            return -1;
        }
        switch (this.order) {
            case 3: {
                if (matchCount.getCount() < matchCount2.getCount()) {
                    return 1;
                }
                if (matchCount.getCount() > matchCount2.getCount()) {
                    return -1;
                }
                return 0;
            }
            case 1: {
                return this.collator.compare(matchCount.getMatch(), matchCount2.getMatch());
            }
            case 4: {
                float f = matchCount.getCp(this.ctest);
                float f2 = matchCount2.getCp(this.ctest);
                if (f < f2) {
                    return 1;
                }
                if (f > f2) {
                    return -1;
                }
                return 0;
            }
        }
        return 0;
    }

    public String getTestName() {
        if (this.order != 4) {
            return "";
        }
        return this.testName;
    }
}

