/*
 * Decompiled with CFR 0.152.
 */
package ipipan.poliqarp.stat;

import ipipan.poliqarp.logic.Job;
import ipipan.poliqarp.logic.Match;
import ipipan.poliqarp.logic.MatchList;
import ipipan.poliqarp.stat.MatchCount;
import ipipan.poliqarp.stat.MatchCountComparator;
import ipipan.poliqarp.stat.MatchCountGuiComparator;
import ipipan.poliqarp.stat.Selector;
import ipipan.poliqarp.stat.SimpleMatchCounter;
import ipipan.poliqarp.stat.StatQueryException;
import ipipan.poliqarp.stat.Tagset;
import ipipan.poliqarp.stat.TimeWatch;
import ipipan.poliqarp.stat.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;

public class MatchCounter
extends SimpleMatchCounter
implements Job {
    private static final MatchCount[] fakeArray = new MatchCount[0];
    MatchCountComparator sortOrder = null;
    TimeWatch timer = new TimeWatch();
    int countLimit = 1000;
    int displLimit = 10;
    int occurLimit = 1;
    SimpleMatchCounter left = null;
    SimpleMatchCounter right = null;
    MatchCount[] countArray = null;
    String groupby;
    String leftGroupby;
    String rightGroupby;
    int maxCount = 0;

    public MatchCounter(String string, Tagset tagset) throws StatQueryException {
        this.groupby = this.stripModifiers(string);
        int n = this.groupby.indexOf(59);
        if (n != -1) {
            this.leftGroupby = this.groupby.substring(0, n).trim();
            this.left = new SimpleMatchCounter(this.leftGroupby, tagset);
            this.rightGroupby = this.groupby.substring(n + 1).trim();
            this.right = new SimpleMatchCounter(this.rightGroupby, tagset);
        } else {
            this.leftGroupby = this.groupby;
            this.rightGroupby = "";
            this.selector = new Selector(this.groupby, tagset);
        }
    }

    private int modifierEndPosition(String string, int n) throws StatQueryException {
        boolean bl = false;
        boolean bl2 = false;
        int n2 = -1;
        int n3 = string.length();
        if (string.regionMatches(n, " display ", 0, 9)) {
            bl = true;
            n2 = 9;
        } else if (string.regionMatches(n, " min ", 0, 5)) {
            bl = true;
            n2 = 5;
        } else if (string.regionMatches(n, " count ", 0, 7)) {
            bl = true;
            bl2 = true;
            n2 = 7;
        } else if (string.regionMatches(n, " sort ", 0, 6)) {
            n2 = 6;
        } else {
            throw new StatQueryException();
        }
        n2 += n;
        if (bl) {
            if (bl2 && string.regionMatches(n2, "all", 0, 3)) {
                return n2 + 3;
            }
            while (n2 < n3 && Character.isDigit(string.charAt(n2))) {
                ++n2;
            }
            return n2;
        }
        if (string.regionMatches(n2, "a fronte", 0, 8)) {
            return n2 + 8;
        }
        if (string.regionMatches(n2, "a tergo", 0, 7)) {
            return n2 + 7;
        }
        if (string.regionMatches(n2, "by ", 0, 3)) {
            if (string.regionMatches(n2 += 3, "freq", 0, 4)) {
                return n2 + 4;
            }
            if (string.regionMatches(n2, "maxcp", 0, 5)) {
                return n2 + 5;
            }
            if (string.regionMatches(n2, "dice", 0, 4)) {
                return n2 + 4;
            }
            if (string.regionMatches(n2, "cp", 0, 2)) {
                return n2 + 2;
            }
            if (string.regionMatches(n2, "scp bias ", 0, 9)) {
                n2 += 9;
                while (n2 < n3 && string.charAt(n2) != ' ') {
                    ++n2;
                }
                return n2;
            }
            if (string.regionMatches(n2, "scp", 0, 3)) {
                return n2 + 3;
            }
        }
        throw new StatQueryException();
    }

    String stripModifiers(String string) throws StatQueryException {
        int n;
        int n2 = string.indexOf(" display ");
        if (n2 != -1) {
            n = this.modifierEndPosition(string, n2);
            this.displLimit = Util.safeParseInt(string.substring(n2 + 9, n), this.displLimit);
            string = string.substring(0, n2) + string.substring(n);
        }
        if ((n2 = string.indexOf(" count ")) != -1) {
            n = this.modifierEndPosition(string, n2);
            this.countLimit = Util.safeParseInt(string.substring(n2 + 7, n), this.countLimit);
            string = string.substring(0, n2) + string.substring(n);
        }
        if ((n2 = string.indexOf(" min ")) != -1) {
            n = this.modifierEndPosition(string, n2);
            this.occurLimit = Util.safeParseInt(string.substring(n2 + 5, n), this.occurLimit);
            string = string.substring(0, n2) + string.substring(n);
        }
        if ((n2 = string.indexOf(" sort ")) != -1) {
            n = this.modifierEndPosition(string, n2);
            this.sortOrder = new MatchCountComparator(string.substring(n2 + 6, n));
            string = string.substring(0, n2) + string.substring(n);
        }
        return string;
    }

    public MatchCount count(Match match, int n) {
        if ((this.counted + 1) % 1000 == 0) {
            System.out.println("MatchCounter.count(" + (n + 1) + "): " + (this.counted + 1));
        }
        if (this.left == null) {
            return super.count(match, n);
        }
        MatchCount matchCount = this.left.count(match, n);
        MatchCount matchCount2 = this.right.count(match, n);
        String string = matchCount.getMatch() + "\t" + matchCount2.getMatch();
        MatchCount matchCount3 = (MatchCount)this.count.get(string);
        if (matchCount3 == null) {
            matchCount3 = new MatchCount(string, matchCount, matchCount2, n);
            this.count.put(string, matchCount3);
        } else {
            matchCount3.inc();
        }
        ++this.counted;
        return matchCount3;
    }

    public void count(MatchList matchList) {
        int n = 0;
        int n2 = matchList.count();
        long l = 0L;
        long l2 = 0L;
        this.timer.display("MatchCounter.start(): ");
        try {
            if (this.countLimit >= n2 - n) {
                this.countLimit = -1;
            }
            if (this.countLimit < 0) {
                this.maxCount = n2;
                while (n < n2) {
                    l2 += this.timer.getInterval();
                    if (n % 1000 == 0) {
                        matchList.prefetchMatches(n, n + 1000);
                    }
                    Match match = matchList.getMatch(n);
                    l += this.timer.getInterval();
                    this.count(match, n);
                    ++n;
                }
            } else {
                Random random = new Random();
                this.maxCount = this.countLimit;
                while (this.countLimit > 0) {
                    if ((n += random.nextInt((n2 - n) / this.countLimit) + 1) >= n2) {
                        n = n2 - 1;
                    }
                    l2 += this.timer.getInterval();
                    Match match = matchList.getMatch(n);
                    l += this.timer.getInterval();
                    this.count(match, n);
                    --this.countLimit;
                }
            }
            System.out.println("MatchCounter.count(): mTime: " + l + " ms; sTime: " + l2 + " ms");
            this.timer.seset();
            this.toArray();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void toArray() {
        if (this.occurLimit > 1) {
            ArrayList<MatchCount> arrayList = new ArrayList<MatchCount>();
            for (MatchCount matchCount : this.count.values()) {
                if (matchCount.getCount() < this.occurLimit) continue;
                arrayList.add(matchCount);
            }
            this.countArray = arrayList.toArray(fakeArray);
        } else {
            this.countArray = this.count.values().toArray(fakeArray);
        }
        if (this.sortOrder != null) {
            Arrays.sort(this.countArray, this.sortOrder);
            this.timer.display("MatchCounter.sort(): ");
        }
    }

    public String[] getCount(int n) {
        return this.countArray[n].toStringArray();
    }

    public Match getCells(int n) {
        return new Match(this.countArray[n].toCellArray());
    }

    public String[] getColumnNames() {
        String[] stringArray = null;
        if (this.right == null) {
            stringArray = new String[]{this.leftGroupby, "c(" + this.groupby + ")"};
            return stringArray;
        }
        stringArray = this.sortOrder != null && !this.sortOrder.getTestName().equals("") ? new String[6] : new String[5];
        stringArray[0] = this.leftGroupby;
        stringArray[1] = this.rightGroupby;
        stringArray[2] = this.left != null ? "c(" + this.leftGroupby + ")" : "";
        stringArray[3] = this.right != null ? "c(" + this.rightGroupby + ")" : "";
        stringArray[4] = "c(" + this.groupby + ")";
        if (this.sortOrder != null && !this.sortOrder.getTestName().equals("")) {
            stringArray[5] = this.sortOrder.getTestName();
        }
        return stringArray;
    }

    public int getMatchRef(int n) {
        return this.countArray[n].getMatchRef();
    }

    public int count() {
        return this.countArray != null ? this.countArray.length : this.count.size();
    }

    public void print() {
        int n = 0;
        if (this.displLimit > this.countArray.length || this.displLimit < 0) {
            this.displLimit = this.countArray.length;
        }
        for (int i = 0; i < this.displLimit; ++i) {
            System.out.println(this.countArray[i].toString());
            n += this.countArray[i].getCount();
        }
        System.out.println("RAZEM: " + n + " (" + this.counted + ")");
    }

    public int getProgress() {
        return this.maxCount > 0 ? this.counted * 100 / this.maxCount : 0;
    }

    public void sort(int n, boolean bl) {
        Arrays.sort(this.countArray, new MatchCountGuiComparator(n, bl));
    }
}

