/*
 * Decompiled with CFR 0.152.
 */
package ipipan.poliqarp.stat;

import ipipan.poliqarp.stat.AttrValueComparator;
import ipipan.poliqarp.stat.PosAttribute;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Comparator;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tagset {
    public static final String undefinedValue = "[-]";
    TreeMap<String, PosAttribute[]> posAttributes = new TreeMap();
    TreeMap<String, String[]> attrValues;
    TreeMap<String, String> aliases = new TreeMap();
    TreeMap<String, Integer> valOrder = new TreeMap();
    private static final int LOAD_IGNORE = 0;
    private static final int LOAD_POS = 1;
    private static final int LOAD_NAMED = 2;
    private static final int LOAD_ATTR = 3;

    public Tagset(String string) {
        this.loadCfgFile(string + ".cfg");
        System.err.println("Tagset(): " + this.posAttributes.size() + " pos, " + this.aliases.size() + " aliases loaded.");
    }

    void loadCfgFile(String string) {
        int n = 0;
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "utf-8"));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                if (!(string2 = string2.trim()).startsWith("#") && string2.length() != 0) {
                    if (string2.startsWith("[")) {
                        n = string2.equals("[POS]") ? 1 : (string2.equals("[NAMED-ENTITY]") ? 2 : (string2.equals("[ATTR]") ? 3 : 0));
                    } else {
                        switch (n) {
                            case 1: {
                                this.setPosAttributes(string2);
                                break;
                            }
                            case 2: {
                                this.addAliases(string2);
                                break;
                            }
                            case 3: {
                                this.setAttrValues(string2);
                                break;
                            }
                        }
                    }
                }
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    String[] splitLine(String string) {
        return string.split("(\\s*=\\s*)|\\s+");
    }

    void setPosAttributes(String string) {
        String[] stringArray = this.splitLine(string);
        PosAttribute[] posAttributeArray = new PosAttribute[stringArray.length - 1];
        for (int i = 1; i < stringArray.length; ++i) {
            posAttributeArray[i - 1] = new PosAttribute(stringArray[i]);
            this.aliases.put(stringArray[i], stringArray[i]);
        }
        this.posAttributes.put(stringArray[0], posAttributeArray);
    }

    void addAliases(String string) {
        String[] stringArray = this.splitLine(string);
        for (int i = 1; i < stringArray.length; ++i) {
            this.aliases.put(stringArray[i], stringArray[0]);
        }
    }

    void setAttrValues(String string) {
        String[] stringArray = this.splitLine(string);
        for (int i = 1; i < stringArray.length; ++i) {
            this.valOrder.put(stringArray[i], i);
        }
    }

    public String getBaseName(String string) {
        return this.aliases.get(string);
    }

    public Comparator<String> getAttrValueComparator() {
        return new AttrValueComparator(this.valOrder);
    }

    public String getAttrValue(String string, String string2) {
        int n;
        String[] stringArray = string.split(":");
        if (string2.equals(this.aliases.get("pos"))) {
            return stringArray[0];
        }
        PosAttribute[] posAttributeArray = this.posAttributes.get(stringArray[0]);
        if (posAttributeArray == null) {
            System.err.println("Tagset.getAttrValue(): no attributes for <" + stringArray[0] + ">");
        }
        if (posAttributeArray.length != stringArray.length - 1) {
            System.err.println("Tagset.getAttrValue(): no of attributes does not match: " + posAttributeArray.length + " vs " + (stringArray.length - 1));
        }
        for (n = 0; n < posAttributeArray.length && !posAttributeArray[n].name.equals(string2); ++n) {
        }
        if (n == posAttributeArray.length) {
            return undefinedValue;
        }
        return stringArray[n + 1];
    }
}

