/*
 * Decompiled with CFR 0.152.
 */
package ipipan.poliqarp.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import ipipan.poliqarp.gui.Application;
import ipipan.poliqarp.gui.Configuration;
import ipipan.poliqarp.gui.MetaDataConstraint;
import ipipan.poliqarp.gui.MetaDataConstraintModel;
import ipipan.poliqarp.gui.MetaDataConstraintSet;
import ipipan.poliqarp.util.HotString;
import ipipan.poliqarp.util.PoliqarpUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public final class ConfigDialog
extends JDialog {
    private static final int CMD_OK = 1;
    private static final int CMD_CANCEL = 2;
    private static final int CMD_ADD = 3;
    private static final int CMD_DELETE = 4;
    private Configuration cfg;
    private Configuration old;
    private Application app;
    private ActionListener bal;
    private AliasModel aliasModel;
    private Set<MetaDataConstraint> constraintWidgets;
    private int selectedIndex;

    private void updateAliases() {
        if (!this.app.isConnected() || this.app.getCorpus() == null) {
            return;
        }
        Vector<String[]> vector = this.aliasModel.getNewAliases();
        Vector<String> vector2 = this.aliasModel.getDeletedAliases();
        try {
            for (String[] object : vector) {
                this.app.getCorpus().defineAlias(object[0], object[1]);
            }
            for (String string : vector2) {
                this.app.getCorpus().deleteAlias(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private JButton createButton(int n, String string) {
        JButton jButton = new JButton(this.cfg.getComponentName("TEXT_" + string));
        jButton.setActionCommand("" + n);
        jButton.addActionListener(this.bal);
        return jButton;
    }

    public ConfigDialog(JFrame jFrame, Application application) {
        super(jFrame, application.getConfig().getComponentName("TEXT_CONFIG_DIALOG_TITLE"), true);
        this.app = application;
        this.old = application.getConfig();
        this.cfg = (Configuration)this.old.clone();
        this.bal = new ButtonActionListener();
        JPanel jPanel = this.createMainPanel();
        this.setContentPane(jPanel);
        Dimension dimension = new Dimension(600, 400);
        this.setSize(dimension);
        dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
    }

    public void launch() {
        this.setVisible(true);
    }

    private JPanel createMainPanel() {
        JPanel jPanel = new JPanel();
        ColumnSpec columnSpec = new ColumnSpec((Size)Sizes.DLUX2);
        ColumnSpec columnSpec2 = new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0);
        ColumnSpec columnSpec3 = new ColumnSpec((Size)Sizes.DEFAULT);
        RowSpec rowSpec = new RowSpec((Size)Sizes.DLUX2);
        RowSpec rowSpec2 = new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0);
        RowSpec rowSpec3 = new RowSpec((Size)Sizes.DEFAULT);
        ColumnSpec[] columnSpecArray = new ColumnSpec[]{columnSpec2};
        RowSpec[] rowSpecArray = new RowSpec[]{rowSpec2, rowSpec, rowSpec3};
        jPanel.setLayout((LayoutManager)new FormLayout(columnSpecArray, rowSpecArray));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)this.createTabs(), new CellConstraints(1, 1));
        jPanel.add((Component)this.createButtonPanel(), new CellConstraints(1, 3));
        return jPanel;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.add(this.createButton(1, "OK"));
        jPanel.add(this.createButton(2, "CANCEL"));
        return jPanel;
    }

    private void addTab(JTabbedPane jTabbedPane, String string, Component component) {
        jTabbedPane.addTab(this.cfg.getComponentName("TEXT_CONFIG_" + string), component);
    }

    private JPanel createDummyPanel() {
        return new JPanel();
    }

    private JPanel center(Component component) {
        JPanel jPanel = new JPanel(new GridLayout(1, 1));
        jPanel.add(component, "Center");
        return jPanel;
    }

    private JSpinner createSpinner(int n, int n2, String string) {
        int n3 = Integer.parseInt(this.cfg.getConfigItem(string));
        JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(n3, n, n2, 1));
        final String string2 = string;
        jSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSpinner jSpinner = (JSpinner)changeEvent.getSource();
                ConfigDialog.this.cfg.addConfigItem(string2, "" + ((SpinnerNumberModel)jSpinner.getModel()).getNumber().intValue());
            }
        });
        return jSpinner;
    }

    private JTextField createTextField(String string) {
        String string2 = this.cfg.getConfigItem(string);
        JTextField jTextField = new JTextField(string2);
        final String string3 = string;
        jTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTextField jTextField = (JTextField)actionEvent.getSource();
                ConfigDialog.this.cfg.addConfigItem(string3, jTextField.getText());
            }
        });
        return jTextField;
    }

    private JLabel createLabel(String string, Component component) {
        String string2 = this.cfg.getComponentName("TEXT_CONFIG_" + string);
        HotString hotString = PoliqarpUtilities.getHotKey(string2);
        JLabel jLabel = new JLabel(hotString.toString());
        jLabel.setHorizontalAlignment(11);
        jLabel.setLabelFor(component);
        if (hotString.isHotKey()) {
            jLabel.setDisplayedMnemonic(hotString.getHotKey());
        }
        return jLabel;
    }

    private JPanel createContextTab() {
        JPanel jPanel = new JPanel();
        ColumnSpec columnSpec = new ColumnSpec((Size)Sizes.DLUX2);
        ColumnSpec columnSpec2 = new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0);
        ColumnSpec columnSpec3 = new ColumnSpec((Size)Sizes.DEFAULT);
        RowSpec rowSpec = new RowSpec((Size)Sizes.DLUX2);
        RowSpec rowSpec2 = new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0);
        RowSpec rowSpec3 = new RowSpec((Size)Sizes.DEFAULT);
        ColumnSpec[] columnSpecArray = new ColumnSpec[]{columnSpec2, columnSpec3, columnSpec, columnSpec3, columnSpec2};
        RowSpec[] rowSpecArray = new RowSpec[]{rowSpec2, rowSpec3, rowSpec, rowSpec3, rowSpec, rowSpec3, rowSpec2};
        jPanel.setLayout((LayoutManager)new FormLayout(columnSpecArray, rowSpecArray));
        CellConstraints cellConstraints = new CellConstraints();
        jPanel.setLayout((LayoutManager)new FormLayout("default:grow, default, 2dlu, default, default:grow", "default:grow, default, 2dlu, default, 2dlu, default, default:grow"));
        JSpinner jSpinner = this.createSpinner(1, 10, "left-context");
        jPanel.add((Component)this.createLabel("LC", jSpinner), cellConstraints.xy(2, 2));
        jPanel.add((Component)jSpinner, cellConstraints.xy(4, 2));
        jSpinner = this.createSpinner(1, 10, "right-context");
        jPanel.add((Component)this.createLabel("RC", jSpinner), cellConstraints.xy(2, 4));
        jPanel.add((Component)jSpinner, cellConstraints.xy(4, 4));
        jSpinner = this.createSpinner(1, 200, "wide-context");
        jPanel.add((Component)this.createLabel("WC", jSpinner), cellConstraints.xy(2, 6));
        jPanel.add((Component)jSpinner, cellConstraints.xy(4, 6));
        return jPanel;
    }

    private JComboBox createComboBox(String string, int n) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i = 0; i < n; ++i) {
            jComboBox.addItem(this.cfg.getComponentName("TEXT_CONFIG_COMBO_" + string + "_" + i));
        }
        return jComboBox;
    }

    private JRadioButton createRadioButton(String string) {
        String string2 = this.cfg.getComponentName("TEXT_CONFIG_" + string);
        HotString hotString = PoliqarpUtilities.getHotKey(string2);
        JRadioButton jRadioButton = new JRadioButton(hotString.toString());
        if (hotString.isHotKey()) {
            jRadioButton.setMnemonic(hotString.getHotKey());
        }
        return jRadioButton;
    }

    private JPanel createSortingTab() {
        JPanel jPanel = new JPanel();
        CellConstraints cellConstraints = new CellConstraints();
        ColumnSpec columnSpec = new ColumnSpec((Size)Sizes.DLUX2);
        ColumnSpec columnSpec2 = new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0);
        ColumnSpec columnSpec3 = new ColumnSpec((Size)Sizes.DEFAULT);
        RowSpec rowSpec = new RowSpec((Size)Sizes.DLUX2);
        RowSpec rowSpec2 = new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0);
        RowSpec rowSpec3 = new RowSpec((Size)Sizes.DEFAULT);
        ColumnSpec[] columnSpecArray = new ColumnSpec[]{columnSpec2, columnSpec3, columnSpec, columnSpec3, columnSpec, columnSpec3, columnSpec, columnSpec3, columnSpec2};
        RowSpec[] rowSpecArray = new RowSpec[]{rowSpec2, rowSpec3, rowSpec, rowSpec3, rowSpec2};
        jPanel.setLayout((LayoutManager)new FormLayout(columnSpecArray, rowSpecArray));
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButton jRadioButton = this.createRadioButton("NOSORTBTN");
        final JRadioButton jRadioButton2 = this.createRadioButton("SORTBTN");
        jPanel.add((Component)jRadioButton, cellConstraints.xywh(2, 2, 7, 1));
        jPanel.add((Component)jRadioButton2, cellConstraints.xy(2, 4));
        final JComboBox jComboBox = this.createComboBox("WHAT", 4);
        jPanel.add((Component)jComboBox, cellConstraints.xy(4, 4));
        final JComboBox jComboBox2 = this.createComboBox("ALPHA", 2);
        jPanel.add((Component)jComboBox2, cellConstraints.xy(6, 4));
        final JComboBox jComboBox3 = this.createComboBox("ASC", 2);
        jPanel.add((Component)jComboBox3, cellConstraints.xy(8, 4));
        String string = this.cfg.getConfigItem("sort-by");
        final SortingComboBoxListener sortingComboBoxListener = new SortingComboBoxListener(string, jComboBox, jComboBox2, jComboBox3);
        ButtonActionListener buttonActionListener = new ButtonActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = actionEvent.getSource() == jRadioButton2;
                jComboBox.setEnabled(bl);
                jComboBox2.setEnabled(bl);
                jComboBox3.setEnabled(bl);
                if (bl) {
                    sortingComboBoxListener.updateConfig();
                } else {
                    Configuration configuration = ConfigDialog.this.cfg;
                    ConfigDialog.this.cfg;
                    configuration.addConfigItem("sort-by", "");
                }
            }
        };
        jRadioButton.addActionListener(buttonActionListener);
        jRadioButton2.addActionListener(buttonActionListener);
        if (string.equals("")) {
            jRadioButton.doClick();
        } else {
            jRadioButton2.doClick();
        }
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        return jPanel;
    }

    private JCheckBox createCheckBox(String string, String string2, boolean bl) {
        String string3 = this.cfg.getComponentName("TEXT_CONFIG_" + string);
        JCheckBox jCheckBox = new JCheckBox(string3);
        try {
            jCheckBox.setSelected(this.cfg.getConfigItem(string2).equals("yes"));
        }
        catch (NoSuchElementException noSuchElementException) {
            jCheckBox.setSelected(bl);
        }
        final String string4 = string2;
        jCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ConfigDialog.this.cfg.addConfigItem(string4, itemEvent.getStateChange() == 1 ? "yes" : "no");
            }
        });
        return jCheckBox;
    }

    private JPanel createFormatPanel(String string, boolean bl) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.cfg.getComponentName("TEXT_CONFIG_" + string)), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.add(this.createCheckBox("FMT_ORTH", bl ? "display-orth" : "display-orth-context", true));
        jPanel.add(this.createCheckBox("FMT_BASE", bl ? "display-base" : "display-base-context", bl));
        jPanel.add(this.createCheckBox("FMT_TAG", bl ? "display-tag" : "display-tag-context", bl));
        return jPanel;
    }

    private JPanel createFormatTab() {
        JPanel jPanel = new JPanel();
        ColumnSpec columnSpec = new ColumnSpec((Size)Sizes.DLUX2);
        ColumnSpec columnSpec2 = new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0);
        ColumnSpec columnSpec3 = new ColumnSpec((Size)Sizes.DEFAULT);
        RowSpec rowSpec = new RowSpec((Size)Sizes.DLUX6);
        RowSpec rowSpec2 = new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0);
        RowSpec rowSpec3 = new RowSpec((Size)Sizes.DEFAULT);
        ColumnSpec[] columnSpecArray = new ColumnSpec[]{columnSpec2, columnSpec3, columnSpec, columnSpec3, columnSpec2};
        RowSpec[] rowSpecArray = new RowSpec[]{rowSpec2, rowSpec3, rowSpec, rowSpec3, rowSpec2};
        CellConstraints cellConstraints = new CellConstraints();
        jPanel.setLayout((LayoutManager)new FormLayout(columnSpecArray, rowSpecArray));
        jPanel.add((Component)this.createFormatPanel("FMT_MATCH", true), cellConstraints.xy(2, 2));
        jPanel.add((Component)this.createFormatPanel("CONTEXT", false), cellConstraints.xy(4, 2));
        jPanel.add((Component)this.createCheckBox("FMT_DISAMB", "display-disambiguated-tags", true), cellConstraints.xywh(2, 4, 3, 1));
        return jPanel;
    }

    private JPanel createFlagsTab() {
        JPanel jPanel = new JPanel();
        ColumnSpec columnSpec = new ColumnSpec((Size)Sizes.DLUX2);
        ColumnSpec columnSpec2 = new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0);
        ColumnSpec columnSpec3 = new ColumnSpec((Size)Sizes.DEFAULT);
        RowSpec rowSpec = new RowSpec((Size)Sizes.DLUX2);
        RowSpec rowSpec2 = new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0);
        RowSpec rowSpec3 = new RowSpec((Size)Sizes.DEFAULT);
        ColumnSpec[] columnSpecArray = new ColumnSpec[]{columnSpec2, columnSpec3, columnSpec, columnSpec3, columnSpec2};
        RowSpec[] rowSpecArray = new RowSpec[]{rowSpec2, rowSpec3, rowSpec2};
        CellConstraints cellConstraints = new CellConstraints();
        jPanel.setLayout((LayoutManager)new FormLayout(columnSpecArray, rowSpecArray));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 3));
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.cfg.getComponentName("TEXT_CONFIG_FLAGS_QUERY")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        jPanel2.add(this.createCheckBox("FLAGS_I", "query-i", true));
        jPanel2.add(this.createCheckBox("FLAGS_X", "query-x", true));
        jPanel.add((Component)jPanel2, cellConstraints.xy(2, 2));
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 3));
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.cfg.getComponentName("TEXT_TOGGLE0")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        jPanel2.add(this.createCheckBox("FLAGS_I", "meta-i", false));
        jPanel2.add(this.createCheckBox("FLAGS_X", "meta-x", false));
        jPanel.add((Component)jPanel2, cellConstraints.xy(4, 2));
        return jPanel;
    }

    private JTable createAliasTable() {
        this.aliasModel = new AliasModel();
        JTable jTable = new JTable(this.aliasModel);
        jTable.setSelectionMode(0);
        return jTable;
    }

    private JPanel createAliasTab() {
        JPanel jPanel = new JPanel();
        CellConstraints cellConstraints = new CellConstraints();
        ColumnSpec columnSpec = new ColumnSpec((Size)Sizes.DLUX2);
        ColumnSpec columnSpec2 = new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0);
        ColumnSpec columnSpec3 = new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 8.0);
        ColumnSpec columnSpec4 = new ColumnSpec((Size)Sizes.DEFAULT);
        RowSpec rowSpec = new RowSpec((Size)Sizes.DLUX2);
        RowSpec rowSpec2 = new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0);
        RowSpec rowSpec3 = new RowSpec((Size)Sizes.DEFAULT);
        ColumnSpec[] columnSpecArray = new ColumnSpec[]{columnSpec2, columnSpec3, columnSpec2};
        RowSpec[] rowSpecArray = new RowSpec[]{rowSpec2, rowSpec3, rowSpec, rowSpec3, rowSpec2};
        jPanel.setLayout((LayoutManager)new FormLayout(columnSpecArray, rowSpecArray));
        JTable jTable = this.createAliasTable();
        jTable.getColumnModel().getColumn(0).setPreferredWidth(100);
        jTable.getColumnModel().getColumn(1).setPreferredWidth(300);
        int n = Integer.parseInt(this.cfg.getConfigItem("gui-font-size"));
        n = n * 16 / 11;
        jTable.setRowHeight(n);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setPreferredSize(new Dimension(400, 100));
        jPanel.add((Component)jScrollPane, cellConstraints.xy(2, 2));
        JPanel jPanel2 = new JPanel();
        ColumnSpec[] columnSpecArray2 = new ColumnSpec[]{columnSpec2, columnSpec4, columnSpec, columnSpec4, columnSpec2};
        RowSpec[] rowSpecArray2 = new RowSpec[]{rowSpec3};
        jPanel2.setLayout((LayoutManager)new FormLayout(columnSpecArray2, rowSpecArray2));
        jPanel2.add((Component)this.createButton(3, "ADD"), cellConstraints.xy(2, 1));
        final JButton jButton = this.createButton(4, "DELETE");
        jPanel2.add((Component)jButton, cellConstraints.xy(4, 1));
        jButton.setEnabled(false);
        jPanel.add((Component)jPanel2, cellConstraints.xy(2, 4));
        jTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                ConfigDialog.this.selectedIndex = listSelectionModel.getMinSelectionIndex();
                jButton.setEnabled(ConfigDialog.this.selectedIndex != -1);
            }
        });
        return jPanel;
    }

    private JPanel createAdvancedTab() {
        JPanel jPanel = new JPanel();
        CellConstraints cellConstraints = new CellConstraints();
        ColumnSpec columnSpec = new ColumnSpec((Size)Sizes.DLUX6);
        ColumnSpec columnSpec2 = new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0);
        ColumnSpec columnSpec3 = new ColumnSpec((Size)Sizes.DEFAULT);
        RowSpec rowSpec = new RowSpec((Size)Sizes.DLUX2);
        RowSpec rowSpec2 = new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0);
        RowSpec rowSpec3 = new RowSpec((Size)Sizes.DEFAULT);
        ColumnSpec[] columnSpecArray = new ColumnSpec[]{columnSpec2, columnSpec3, columnSpec, columnSpec3, columnSpec2};
        RowSpec[] rowSpecArray = new RowSpec[]{rowSpec2, rowSpec3, rowSpec, rowSpec3, rowSpec2};
        jPanel.setLayout((LayoutManager)new FormLayout(columnSpecArray, rowSpecArray));
        JTextField jTextField = this.createTextField("server");
        jPanel.add((Component)this.createLabel("CONNECTION_SERVER", jTextField), cellConstraints.xy(2, 2));
        jPanel.add((Component)jTextField, cellConstraints.xy(4, 2));
        JSpinner jSpinner = this.createSpinner(1024, 65535, "port");
        jPanel.add((Component)this.createLabel("CONNECTION_PORT", jSpinner), cellConstraints.xy(2, 4));
        jPanel.add((Component)jSpinner, cellConstraints.xy(4, 4));
        return jPanel;
    }

    private JPanel createLookAndFeelTab() {
        JPanel jPanel = new JPanel();
        CellConstraints cellConstraints = new CellConstraints();
        ColumnSpec columnSpec = new ColumnSpec((Size)Sizes.DLUX6);
        ColumnSpec columnSpec2 = new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0);
        ColumnSpec columnSpec3 = new ColumnSpec((Size)Sizes.DEFAULT);
        RowSpec rowSpec = new RowSpec((Size)Sizes.DLUX2);
        RowSpec rowSpec2 = new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0);
        RowSpec rowSpec3 = new RowSpec((Size)Sizes.DEFAULT);
        ColumnSpec[] columnSpecArray = new ColumnSpec[]{columnSpec2, columnSpec3, columnSpec, columnSpec3, columnSpec2};
        RowSpec[] rowSpecArray = new RowSpec[]{rowSpec2, rowSpec3, rowSpec2};
        jPanel.setLayout((LayoutManager)new FormLayout(columnSpecArray, rowSpecArray));
        JSpinner jSpinner = this.createSpinner(8, 24, "gui-font-size");
        jPanel.add((Component)this.createLabel("LNF_FONTSIZE", jSpinner), cellConstraints.xy(2, 2));
        jPanel.add((Component)jSpinner, cellConstraints.xy(4, 2));
        return jPanel;
    }

    private JScrollPane createMetaTab() {
        Object object2;
        int n;
        if (this.app.getCorpus() == null) {
            return new JScrollPane(null);
        }
        MetaDataConstraintSet metaDataConstraintSet = this.app.getConstraints();
        this.constraintWidgets = new HashSet<MetaDataConstraint>();
        JPanel jPanel = new JPanel();
        ColumnSpec columnSpec = new ColumnSpec((Size)Sizes.DLUX2);
        ColumnSpec columnSpec2 = new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0);
        ColumnSpec columnSpec3 = new ColumnSpec((Size)Sizes.DEFAULT);
        RowSpec rowSpec = new RowSpec((Size)Sizes.DLUX2);
        RowSpec rowSpec2 = new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0);
        RowSpec rowSpec3 = new RowSpec((Size)Sizes.DEFAULT);
        ColumnSpec[] columnSpecArray = new ColumnSpec[]{columnSpec2, columnSpec3, columnSpec, columnSpec3, columnSpec, columnSpec3, columnSpec, columnSpec3, columnSpec, columnSpec3, columnSpec, columnSpec3, columnSpec2};
        RowSpec[] rowSpecArray = new RowSpec[metaDataConstraintSet.size() * 2 + 1];
        for (n = 0; n < metaDataConstraintSet.size(); ++n) {
            rowSpecArray[2 * n + 1] = rowSpec3;
        }
        for (n = 1; n < metaDataConstraintSet.size(); ++n) {
            rowSpecArray[2 * n] = rowSpec;
        }
        RowSpec rowSpec4 = rowSpec2;
        rowSpecArray[2 * metaDataConstraintSet.size()] = rowSpec4;
        rowSpecArray[0] = rowSpec4;
        jPanel.setLayout((LayoutManager)new FormLayout(columnSpecArray, rowSpecArray));
        n = 1;
        for (Object object2 : metaDataConstraintSet) {
            MetaDataConstraint metaDataConstraint = ((MetaDataConstraintModel)object2).getWidget();
            this.constraintWidgets.add(metaDataConstraint);
            metaDataConstraint.setWidgets(jPanel, n);
            n += 2;
        }
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        object2 = new JPanel();
        ((Container)object2).add(jScrollPane);
        return jScrollPane;
    }

    private JTabbedPane createTabs() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.addTab(jTabbedPane, "CONTEXT", this.createContextTab());
        this.addTab(jTabbedPane, "SORT", this.createSortingTab());
        this.addTab(jTabbedPane, "FMT", this.createFormatTab());
        this.addTab(jTabbedPane, "ALIAS", this.createAliasTab());
        this.addTab(jTabbedPane, "FLAGS", this.createFlagsTab());
        this.addTab(jTabbedPane, "META", this.createMetaTab());
        this.addTab(jTabbedPane, "LNF", this.createLookAndFeelTab());
        if (!this.app.isConnected()) {
            for (int i = 0; i < 7; ++i) {
                jTabbedPane.setEnabledAt(i, false);
            }
        } else if (this.app.getCorpus() == null) {
            jTabbedPane.setEnabledAt(5, false);
        }
        return jTabbedPane;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AliasModel
    extends AbstractTableModel {
        private Vector<Alias> data = new Vector();
        private Map<String, String> mapdata;

        public AliasModel() {
            try {
                this.mapdata = ConfigDialog.this.app.getCorpus().getAliases();
                for (Map.Entry<String, String> entry : this.mapdata.entrySet()) {
                    this.data.add(new Alias(entry.getKey(), entry.getValue(), false));
                }
            }
            catch (Exception exception) {
                this.mapdata = null;
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public String getColumnName(int n) {
            return ConfigDialog.this.cfg.getComponentName("TEXT_ALIAS_COL" + n);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return n2 == 0 ? this.data.get((int)n).name : this.data.get((int)n).value;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        public void remove() {
            this.data.remove(ConfigDialog.this.selectedIndex);
            this.fireTableRowsDeleted(ConfigDialog.this.selectedIndex, ConfigDialog.this.selectedIndex);
        }

        public void add() {
            this.data.add(new Alias("name", "value", true));
            this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            String string = (String)object;
            if (n2 == 1) {
                this.data.get((int)n).value = string;
                this.data.get((int)n).modified = true;
            } else {
                int n3 = -1;
                for (int i = 0; i < this.data.size(); ++i) {
                    if (!this.data.get((int)i).name.equals(string)) continue;
                    n3 = i;
                    break;
                }
                if (n3 != -1) {
                    if (n3 != n) {
                        this.data.get((int)n3).value = this.data.get((int)n).value;
                        this.data.get((int)n3).modified = true;
                        this.fireTableCellUpdated(n3, 1);
                        this.data.remove(n);
                        this.fireTableRowsDeleted(n, n);
                    }
                } else {
                    this.data.get((int)n).name = string;
                    this.data.get((int)n).modified = true;
                }
            }
        }

        public Vector<String> getDeletedAliases() {
            Vector<String> vector = new Vector<String>();
            for (Map.Entry<String, String> entry : this.mapdata.entrySet()) {
                boolean bl = false;
                for (Alias alias : this.data) {
                    if (!alias.name.equals(entry.getKey())) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                vector.add(entry.getKey());
            }
            return vector;
        }

        public Vector<String[]> getNewAliases() {
            Vector<String[]> vector = new Vector<String[]>();
            for (Alias alias : this.data) {
                if (!alias.modified) continue;
                String[] stringArray = new String[]{alias.name, alias.value};
                vector.add(stringArray);
            }
            return vector;
        }

        private class Alias {
            public String name;
            public String value;
            public boolean modified;

            public Alias(String string, String string2, boolean bl) {
                this.name = string;
                this.value = string2;
                this.modified = bl;
            }
        }
    }

    private class SortingComboBoxListener
    implements ItemListener {
        int what;
        int alpha;
        int asc;
        JComboBox whatBox;
        JComboBox alphaBox;
        JComboBox ascBox;

        SortingComboBoxListener(String string, JComboBox jComboBox, JComboBox jComboBox2, JComboBox jComboBox3) {
            this.whatBox = jComboBox;
            this.alphaBox = jComboBox2;
            this.ascBox = jComboBox3;
            if (string.equals("")) {
                this.asc = 0;
                this.alpha = 0;
                this.what = 0;
            } else {
                char c = string.charAt(0);
                this.asc = c < 'a' ? 0 : 1;
                c = Character.toLowerCase(c);
                int n = this.alpha = c < 'e' ? 0 : 1;
                if (this.alpha == 1) {
                    c = (char)(c - 4);
                }
                this.what = c - 97;
            }
            jComboBox.addItemListener(this);
            jComboBox2.addItemListener(this);
            jComboBox3.addItemListener(this);
            jComboBox.setSelectedIndex(this.what);
            jComboBox2.setSelectedIndex(this.alpha);
            jComboBox3.setSelectedIndex(this.asc);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                if (itemEvent.getSource() == this.whatBox) {
                    this.what = this.whatBox.getSelectedIndex();
                } else if (itemEvent.getSource() == this.alphaBox) {
                    this.alpha = this.alphaBox.getSelectedIndex();
                } else if (itemEvent.getSource() == this.ascBox) {
                    this.asc = this.ascBox.getSelectedIndex();
                }
                this.updateConfig();
            }
        }

        void updateConfig() {
            int n = this.what + 65;
            if (this.alpha == 1) {
                n += 4;
            }
            char c = (char)n;
            if (this.asc == 1) {
                c = Character.toLowerCase(c);
            }
            Configuration configuration = ConfigDialog.this.cfg;
            ConfigDialog.this.cfg;
            configuration.addConfigItem("sort-by", "" + c);
        }
    }

    private class ButtonActionListener
    implements ActionListener {
        private ButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            int n = Integer.parseInt(jButton.getActionCommand());
            switch (n) {
                case 1: {
                    ConfigDialog.this.cfg.copyTo(ConfigDialog.this.old);
                    ConfigDialog.this.updateAliases();
                    ConfigDialog.this.app.updateConfig();
                    ConfigDialog.this.app.updateSizes();
                    if (ConfigDialog.this.constraintWidgets != null) {
                        for (MetaDataConstraint metaDataConstraint : ConfigDialog.this.constraintWidgets) {
                            metaDataConstraint.update();
                        }
                    }
                }
                case 2: {
                    ConfigDialog.this.dispose();
                    break;
                }
                case 3: {
                    ConfigDialog.this.aliasModel.add();
                    break;
                }
                case 4: {
                    ConfigDialog.this.aliasModel.remove();
                }
            }
        }
    }
}

