/*
 * Decompiled with CFR 0.152.
 */
package ipipan.poliqarp.gui;

import ipipan.poliqarp.gui.DateConstraintModel;
import ipipan.poliqarp.gui.MetaDataConstraintModel;
import ipipan.poliqarp.gui.TextConstraintModel;
import ipipan.poliqarp.logic.Corpus;
import ipipan.poliqarp.logic.MetaData;
import ipipan.poliqarp.util.Pair;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataConstraintSet
extends HashSet<MetaDataConstraintModel> {
    public MetaDataConstraintSet(Corpus corpus) {
        try {
            List<Pair<MetaData.Type, String>> list = corpus.getMetaTypes();
            for (Pair<MetaData.Type, String> pair : list) {
                switch (pair.first()) {
                    case TEXT: {
                        this.add(new TextConstraintModel(pair.second()));
                        break;
                    }
                    case DATE: {
                        this.add(new DateConstraintModel(pair.second()));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getQueryConstraint() {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder("(");
        for (MetaDataConstraintModel metaDataConstraintModel : this) {
            String string = metaDataConstraintModel.getQueryConstraint();
            if (string == null) continue;
            stringBuilder.append(string);
            stringBuilder.append(" & ");
            bl = true;
        }
        if (bl) {
            stringBuilder.delete(stringBuilder.length() - 3, stringBuilder.length());
        }
        stringBuilder.append(")");
        return bl ? stringBuilder.toString() : null;
    }
}

