/*
 * Decompiled with CFR 0.152.
 */
package ipipan.poliqarp.gui;

import ipipan.poliqarp.gui.Application;
import ipipan.poliqarp.gui.Configuration;
import ipipan.poliqarp.gui.ContextArea;
import ipipan.poliqarp.gui.MetaDataTable;
import ipipan.poliqarp.gui.ResultEvent;
import ipipan.poliqarp.gui.ResultEventListener;
import ipipan.poliqarp.logic.MatchList;
import ipipan.poliqarp.logic.Query;
import ipipan.poliqarp.logic.results.ColumnType;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.DefaultTableModel;

public class ResultModel
extends DefaultTableModel {
    private String[] columnNames;
    private Query query;
    private MatchList matches;
    private Configuration config;
    private int offset;
    private int end;
    private int limit;
    private int total;
    private List<ResultEventListener> listeners;
    private Application app;
    private boolean statModel;

    public ResultModel(Application application) {
        this.app = application;
        this.columnNames = new String[4];
        for (int i = 0; i < 4; ++i) {
            this.columnNames[i] = "" + i;
        }
        this.listeners = new ArrayList<ResultEventListener>();
        this.limit = 50;
        this.total = 0;
        this.end = 0;
        this.offset = 0;
        this.statModel = false;
    }

    public void setColumnNames(Configuration configuration) {
        if (this.statModel) {
            this.columnNames = this.matches.getCounter().getColumnNames();
        } else if (this.query == null) {
            this.columnNames = new String[4];
            for (int i = 0; i < 4; ++i) {
                this.columnNames[i] = configuration.getComponentName("TEXT_COL" + i);
            }
        } else {
            this.columnNames = new String[this.query.getHeader().length];
            int n = 0;
            for (ColumnType columnType : this.query.getHeader()) {
                this.columnNames[n++] = configuration.getComponentName("TEXT_" + columnType.getName());
            }
        }
        this.fireTableStructureChanged();
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.end - this.offset;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        if (this.statModel) {
            return this.matches.getCounter().getCount(n + this.offset)[n2];
        }
        return this.matches.getMatch(n + this.offset).getCell(n2).toString(this.config);
    }

    public void setData(Query query, MatchList matchList, Configuration configuration) {
        this.query = query;
        this.matches = matchList;
        this.config = configuration;
        this.total = 0;
        this.end = 0;
        this.offset = 0;
        this.statModel = matchList != null && matchList.getCounter() != null;
        this.setColumnNames(configuration);
    }

    public int getStartPosition() {
        return this.offset;
    }

    public int getEndPosition() {
        return this.end;
    }

    public int getTotal() {
        return this.total;
    }

    public void addResultEventListener(ResultEventListener resultEventListener) {
        this.listeners.add(resultEventListener);
    }

    public void postEvent(ResultEvent resultEvent) {
        for (ResultEventListener resultEventListener : this.listeners) {
            resultEventListener.resultChanged(resultEvent);
        }
    }

    private void forceRefreshContents(int n, int n2, boolean bl) {
        if (!this.statModel) {
            this.matches.prefetchMatches(n, n2);
        }
        if (bl) {
            this.fireTableRowsInserted(n - this.offset, n2 - this.offset);
        } else {
            this.fireTableDataChanged();
        }
        this.postEvent(new ResultEvent(this, this.config, false));
    }

    public void updateContents() {
        int n = this.offset + this.limit;
        int n2 = this.statModel ? this.matches.getCounter().count() : this.matches.count();
        if (n > n2) {
            n = n2;
        }
        if (n != this.end) {
            this.total = n2;
            int n3 = this.end;
            this.end = n;
            this.forceRefreshContents(n3, this.end, true);
        } else if (n2 != this.total) {
            this.total = n2;
            this.postEvent(new ResultEvent(this, this.config, false));
        }
    }

    public void clear() {
        this.total = 0;
        this.end = 0;
        this.offset = 0;
        this.fireTableDataChanged();
        this.postEvent(new ResultEvent(this, this.config, true));
    }

    public void scrollUp() {
        this.scroll(-this.limit);
    }

    public void scrollDown() {
        this.scroll(this.limit);
    }

    public void setAreaContent(ContextArea contextArea, MetaDataTable metaDataTable, int n) {
        int n2 = this.statModel ? this.matches.getCounter().getMatchRef(this.offset + n) : this.offset + n;
        contextArea.setContent(this.matches, n2);
        metaDataTable.getModel().setSource(this.app.getCorpus(), this.matches.getMetaData(n2));
    }

    private void scroll(int n) {
        this.offset += n;
        if (this.offset < 0) {
            this.offset = 0;
        }
        if (this.offset >= this.total) {
            this.offset = this.total - 1;
        }
        this.end = this.offset + this.limit;
        if (this.end > this.total) {
            this.end = this.total;
        }
        this.forceRefreshContents(this.offset, this.end, false);
    }

    public void refreshResults() {
        if (this.matches != null) {
            this.matches.invalidate();
            this.forceRefreshContents(this.offset, this.end, false);
        }
    }

    public boolean isStatistical() {
        return this.statModel;
    }

    public void sortStat(int n, boolean bl) {
        this.matches.getCounter().sort(n, bl);
    }
}

