/*
 * Decompiled with CFR 0.152.
 */
package ipipan.poliqarp.gui;

import ipipan.poliqarp.gui.Configuration;
import ipipan.poliqarp.logic.Match;
import ipipan.poliqarp.logic.Query;
import ipipan.poliqarp.logic.results.ColumnType;
import ipipan.poliqarp.stat.MatchCounter;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import javax.swing.JDialog;

public abstract class ResultWriter {
    protected PrintWriter writer;
    protected Configuration cfg;
    protected int numCols;
    protected String[] colHeaders;

    public ResultWriter() {
        this.cfg = null;
    }

    public ResultWriter(Configuration configuration) {
        this.cfg = configuration;
    }

    protected abstract void writeHeader(Query var1, String var2);

    protected abstract void writeMatch(Match var1);

    protected void writeMatches(Query query) {
        Iterator<Match> iterator = query.getMatchList().getIterator();
        while (iterator.hasNext()) {
            this.writeMatch(iterator.next());
        }
    }

    protected void writeFooter() {
    }

    public void writeResults(String string, Query query, String string2, JDialog jDialog) throws IOException {
        MatchCounter matchCounter = query.getMatchList().getCounter();
        if (matchCounter == null) {
            ColumnType[] columnTypeArray = query.getHeader();
            this.colHeaders = new String[columnTypeArray.length];
            for (int i = 0; i < columnTypeArray.length; ++i) {
                this.colHeaders[i] = this.cfg.getComponentName("TEXT_" + columnTypeArray[i].getName());
            }
        } else {
            this.colHeaders = matchCounter.getColumnNames();
        }
        this.numCols = this.colHeaders.length;
        query.setDirectUnsafeMode(true);
        this.writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), string2)));
        this.writeHeader(query, string2);
        this.writeMatches(query);
        this.writeFooter();
        this.writer.close();
        query.setDirectUnsafeMode(false);
    }
}

