/*
 * Decompiled with CFR 0.152.
 */
package ipipan.poliqarp.logic;

import ipipan.poliqarp.connection.AsyncHandler;
import ipipan.poliqarp.connection.Message;
import ipipan.poliqarp.connection.PoliqarpConnection;
import ipipan.poliqarp.logic.MatchList;
import ipipan.poliqarp.logic.QueryException;
import ipipan.poliqarp.logic.ServerJob;
import ipipan.poliqarp.logic.results.ColumnType;
import java.io.IOException;
import javax.swing.SwingUtilities;

public final class Query
extends ServerJob
implements AsyncHandler {
    private MatchList results;
    private String queryText;
    private boolean running = false;
    private int bufferSize;
    private ColumnType[] header;
    private static final int initialBufferSize = 500000;
    private static final int maximumBufferSize = 500000;

    private void resizeMatchBuffer(int n) throws QueryException {
        try {
            this.connection.send("BUFFER-RESIZE " + n);
            Message message = this.connection.getMessage();
            if (!message.isOK()) {
                throw new QueryException();
            }
        }
        catch (IOException iOException) {
            throw new QueryException();
        }
    }

    public Query(PoliqarpConnection poliqarpConnection, String string) throws QueryException {
        super(poliqarpConnection);
        this.queryText = string;
        poliqarpConnection.setAsyncHandler(this);
        this.results = MatchList.getMatchList(poliqarpConnection, this);
        try {
            poliqarpConnection.send("MAKE-QUERY " + string);
            Message message = poliqarpConnection.getMessage();
            if (!message.isOK()) {
                throw new QueryException();
            }
            poliqarpConnection.send("GET-COLUMN-TYPES");
            message = poliqarpConnection.getMessage();
            if (!message.isOK()) {
                throw new QueryException();
            }
            String[] stringArray = message.getOKInfo(0).split(":");
            this.header = new ColumnType[stringArray.length];
            int n = 0;
            for (String string2 : stringArray) {
                this.header[n++] = ColumnType.parseColumn(string2);
            }
        }
        catch (Exception exception) {
            throw new QueryException();
        }
        this.bufferSize = 500000;
        this.resizeMatchBuffer(this.bufferSize);
    }

    public ColumnType[] getHeader() {
        return this.header;
    }

    public void handle(String string) {
        if (string.startsWith("QUERY-DONE")) {
            int n = Integer.parseInt(string.split(" ")[1]);
            if (this.running && n == this.bufferSize && n < 500000) {
                this.bufferSize += 500000;
                final Query query = this;
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Query query2 = query;
                        synchronized (query2) {
                            try {
                                Query.this.resizeMatchBuffer(Query.this.bufferSize);
                                Query.this.connection.send("RUN-QUERY 500000");
                                Message message = Query.this.connection.getMessage();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                });
            } else if (this.running) {
                this.running = false;
                this.connection.setAsyncHandler(null);
                this.results.queryDone(n);
                this.launchNotifier();
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public MatchList getMatchList() {
        return this.results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch(Runnable runnable) throws QueryException {
        if (this.running) {
            throw new QueryException();
        }
        this.setNotifier(runnable);
        Query query = this;
        synchronized (query) {
            try {
                this.connection.send("RUN-QUERY 500000");
                Message message = this.connection.getMessage();
                if (!message.isOK()) {
                    throw new QueryException();
                }
            }
            catch (IOException iOException) {
                throw new QueryException();
            }
            this.running = true;
        }
    }

    public synchronized void abort() throws QueryException {
        if (!this.running) {
            throw new QueryException();
        }
        try {
            this.connection.send("CANCEL");
            Message message = this.connection.getMessage();
        }
        catch (IOException iOException) {
            throw new QueryException();
        }
        this.running = false;
    }

    public String toString() {
        return this.queryText;
    }
}

