/*
 * Decompiled with CFR 0.152.
 */
package ipipan.poliqarp.logic;

import ipipan.poliqarp.connection.AsyncHandler;
import ipipan.poliqarp.connection.Message;
import ipipan.poliqarp.connection.PoliqarpConnection;
import ipipan.poliqarp.logic.Job;
import javax.swing.SwingUtilities;

public abstract class ServerJob
implements Job,
AsyncHandler {
    protected PoliqarpConnection connection;
    protected Runnable notifier;
    private int lastProgress = 0;

    public ServerJob(PoliqarpConnection poliqarpConnection) {
        this.connection = poliqarpConnection;
        this.notifier = null;
        this.lastProgress = 0;
    }

    public int getProgress() {
        try {
            this.connection.send("STATUS");
            Message message = this.connection.getMessage();
            if (message.isOK()) {
                this.lastProgress = message.getOKIntInfo(0);
            }
            return this.lastProgress;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void setNotifier(Runnable runnable) {
        this.notifier = runnable;
    }

    protected void launchNotifier() {
        if (this.notifier != null) {
            SwingUtilities.invokeLater(this.notifier);
        }
    }

    public abstract void handle(String var1);

    public void setDirectUnsafeMode(boolean bl) {
        this.connection.setDirectUnsafeMode(bl);
    }
}

