/*
 * Decompiled with CFR 0.152.
 */
package ipipan.poliqarp.stat;

import ipipan.poliqarp.logic.Interpretation;
import ipipan.poliqarp.logic.Match;
import ipipan.poliqarp.logic.Segment;
import ipipan.poliqarp.stat.SelectorPart;
import ipipan.poliqarp.stat.StatQueryException;
import ipipan.poliqarp.stat.Tagset;
import java.util.HashSet;
import java.util.Random;

public class Selector {
    public static final int INTERP_RANDOM = 1;
    public static final int INTERP_FIRST = 2;
    public static final int INTERP_COMBINE = 3;
    private static String[] fakeStringArray = new String[0];
    int interpMode;
    int requirements;
    Random generator;
    SelectorPart[] sel;

    public Selector(String string, Tagset tagset) throws StatQueryException {
        int n = string.indexOf(" interp ");
        if (n > -1) {
            this.interpMode = Selector.getInterpMode(string.substring(n + 8));
            string = string.substring(0, n);
        } else {
            this.interpMode = 1;
        }
        if (this.interpMode == 1) {
            this.generator = new Random();
        }
        String[] stringArray = string.split(" *, *");
        this.sel = new SelectorPart[stringArray.length];
        this.requirements = 0;
        for (n = 0; n < stringArray.length; ++n) {
            this.sel[n] = new SelectorPart(stringArray[n], tagset);
            this.requirements |= this.sel[n].getRequirements();
        }
    }

    static int getInterpMode(String string) {
        if (string.equalsIgnoreCase("random")) {
            return 1;
        }
        if (string.equalsIgnoreCase("first")) {
            return 2;
        }
        if (string.equalsIgnoreCase("combine")) {
            return 3;
        }
        return 0;
    }

    public int getRequirements() {
        return this.requirements;
    }

    public String value(Match match) {
        Segment[] segmentArray;
        StringBuilder stringBuilder = new StringBuilder();
        if (match == null) {
            System.out.println("Selector.value: null match");
        }
        Segment[] segmentArray2 = match.getLeftMatch();
        Segment[] segmentArray3 = match.getRightMatch();
        if (segmentArray2 != null && segmentArray2.length > 0) {
            segmentArray = new Segment[segmentArray3.length + segmentArray2.length];
            System.arraycopy(segmentArray3, 0, segmentArray, 0, segmentArray3.length);
            System.arraycopy(segmentArray2, 0, segmentArray, segmentArray3.length, segmentArray2.length);
        } else {
            segmentArray = segmentArray3;
        }
        for (int i = 0; i < this.sel.length; ++i) {
            int n;
            int n2;
            if (i > 0) {
                stringBuilder.append(' ');
            }
            if ((n2 = this.sel[i].getSegno()) > 0) {
                --n2;
            }
            if (n2 < 0) {
                n2 = segmentArray.length + n2;
            }
            if (n2 < 0 || n2 >= segmentArray.length) {
                stringBuilder.append(' ');
                continue;
            }
            String string = this.sel[i].orthValue(segmentArray[n2]);
            if (string != null) {
                stringBuilder.append(string);
                continue;
            }
            Interpretation[] interpretationArray = segmentArray[n2].getDisamb();
            if (this.interpMode == 1 || this.interpMode == 2) {
                n = this.interpMode == 1 ? this.generator.nextInt(interpretationArray.length) : 0;
                stringBuilder.append(this.sel[i].tagValue(interpretationArray[n]));
                continue;
            }
            HashSet<String> hashSet = new HashSet<String>();
            for (n = 0; n < interpretationArray.length; ++n) {
                hashSet.add(this.sel[i].tagValue(interpretationArray[n]));
            }
            String[] stringArray = hashSet.toArray(fakeStringArray);
            for (n = 0; n < stringArray.length; ++n) {
                if (n > 0) {
                    stringBuilder.append('|');
                }
                stringBuilder.append(stringArray[n]);
            }
        }
        return stringBuilder.toString();
    }
}

