/*
 * Decompiled with CFR 0.152.
 */
package ipipan.poliqarp.util;

import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MRUCollection<E>
extends AbstractCollection<E> {
    private static final int defaultLimit = 10;
    private int limit;
    private LinkedList<E> data;

    public MRUCollection(int n) {
        this.limit = n;
        this.data = new LinkedList();
    }

    public MRUCollection() {
        this(10);
    }

    @Override
    public boolean add(E e) {
        ListIterator listIterator = this.data.listIterator();
        while (listIterator.hasNext()) {
            Object e2 = listIterator.next();
            if (!e.equals(e2)) continue;
            listIterator.remove();
            this.data.addFirst(e2);
            return false;
        }
        if (this.data.size() == this.limit) {
            this.data.removeLast();
        }
        this.data.addFirst(e);
        return true;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public Iterator<E> iterator() {
        return this.data.iterator();
    }

    public E get(int n) {
        return this.data.get(n);
    }
}

