/*
 * Decompiled with CFR 0.152.
 */
package wsdde;

import java.io.IOException;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Random;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import wsdde.general.DatabaseHelper;
import wsdde.general.Utils;

public class ExperimentDescription {
    Document inputDocument;
    Document outputDocument;
    int maxMethod;
    String maxMethodTime;
    int allMethodsNum;
    int paramCombinationNum;
    int paramsNum;
    int[] paramOptionsTable;
    int[] paramTmpTable;

    public ExperimentDescription(Document doc) {
        this.inputDocument = doc;
    }

    private int countConfigurations() {
        int ret;
        int selectionsNum = this.inputDocument.getElementsByTagName("selection").getLength();
        int machineLearningNum = this.inputDocument.getElementsByTagName("machine_learning").getLength();
        int corporaNum = this.inputDocument.getElementsByTagName("corpus").getLength();
        NodeList nl = this.inputDocument.getElementsByTagName("param");
        this.paramsNum = nl.getLength();
        this.paramOptionsTable = new int[nl.getLength()];
        this.paramTmpTable = new int[nl.getLength()];
        this.paramCombinationNum = 1;
        int i = 0;
        while (i < nl.getLength()) {
            int tmpOpt = 0;
            tmpOpt = ((Element)nl.item(i)).getElementsByTagName("param_value").getLength();
            this.paramTmpTable[i] = 1;
            this.paramOptionsTable[i] = tmpOpt;
            int j = 0;
            while (j < i) {
                this.paramTmpTable[j] = this.paramTmpTable[j] * tmpOpt;
                ++j;
            }
            this.paramCombinationNum *= tmpOpt;
            ++i;
        }
        this.allMethodsNum = ret = selectionsNum * machineLearningNum * corporaNum * this.paramCombinationNum;
        return ret;
    }

    private Integer[] getParamIndexesTable(int n) {
        Integer[] ret = new Integer[this.paramsNum];
        int i = 0;
        while (i < this.paramsNum) {
            ret[i] = n / this.paramTmpTable[i];
            n %= this.paramTmpTable[i];
            ++i;
        }
        return ret;
    }

    private void getAllCombinations() {
        Node wsdExperiment = this.outputDocument.getElementsByTagName("wsd_experiment").item(0);
        NodeList corporas = this.inputDocument.getElementsByTagName("corpus");
        NodeList selections = this.inputDocument.getElementsByTagName("selection");
        NodeList mls = this.inputDocument.getElementsByTagName("machine_learning");
        Element fGenerators = (Element)this.inputDocument.getElementsByTagName("feature_generators").item(0);
        Vector<Element> featureGensVector = Utils.getChildElementsVector(fGenerators);
        int methodNum = 0;
        int i = 0;
        while (i < corporas.getLength()) {
            int j = 0;
            while (j < selections.getLength()) {
                int k = 0;
                while (k < mls.getLength()) {
                    int l = 0;
                    while (l < this.paramCombinationNum) {
                        Element wsd = this.outputDocument.createElement("wsd_method");
                        wsd.setAttribute("id", Integer.toString(++methodNum));
                        Element maxMethodTimeElement = this.outputDocument.createElement("max_method_time");
                        maxMethodTimeElement.setTextContent(this.maxMethodTime);
                        wsd.appendChild(maxMethodTimeElement);
                        wsd.appendChild(this.outputDocument.importNode(this.cleanNodeProperties(corporas.item(i)), true));
                        wsd.appendChild(this.outputDocument.importNode(this.cleanNodeProperties(selections.item(j)), true));
                        wsd.appendChild(this.outputDocument.importNode(this.cleanNodeProperties(mls.item(k)), true));
                        Integer[] tmp = this.getParamIndexesTable(l);
                        int p = 0;
                        Element featureGenerators = this.outputDocument.createElement("feature_generators");
                        int m = 0;
                        while (m < featureGensVector.size()) {
                            Element fg = featureGensVector.get(m);
                            Element featureGenerator = this.outputDocument.createElement(fg.getNodeName());
                            NodeList parameters = fg.getElementsByTagName("param");
                            int n = 0;
                            while (n < parameters.getLength()) {
                                Element parameter = this.outputDocument.createElement("param");
                                Element inParameter = (Element)parameters.item(n);
                                parameter.setAttribute("name", inParameter.getAttribute("name"));
                                parameter.setAttribute("value", ((Element)inParameter.getElementsByTagName("param_value").item(tmp[p])).getAttribute("value"));
                                featureGenerator.appendChild(parameter);
                                ++p;
                                ++n;
                            }
                            featureGenerators.appendChild(featureGenerator);
                            ++m;
                        }
                        wsd.appendChild(featureGenerators);
                        wsdExperiment.appendChild(wsd);
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private void getProbCombinations() {
        Node wsdExperiment = this.outputDocument.getElementsByTagName("wsd_experiment").item(0);
        NodeList corporas = this.inputDocument.getElementsByTagName("corpus");
        NodeList selections = this.inputDocument.getElementsByTagName("selection");
        NodeList mls = this.inputDocument.getElementsByTagName("machine_learning");
        Element fGenerators = (Element)this.inputDocument.getElementsByTagName("feature_generators").item(0);
        Vector<Element> featureGensVector = Utils.getChildElementsVector(fGenerators);
        HashSet<String> hs = new HashSet<String>();
        int i = 0;
        while (i < this.maxMethod) {
            Element wsd = this.outputDocument.createElement("wsd_method");
            wsd.setAttribute("id", Integer.toString(i + 1));
            int corpIndex = i * corporas.getLength() / this.maxMethod;
            int selectionIndex = this.chooseNode(selections);
            int mlsIndex = this.chooseNode(mls);
            Element maxMethodTimeElement = this.outputDocument.createElement("max_method_time");
            maxMethodTimeElement.setTextContent(this.maxMethodTime);
            wsd.appendChild(maxMethodTimeElement);
            wsd.appendChild(this.outputDocument.importNode(this.cleanNodeProperties(corporas.item(corpIndex)), true));
            wsd.appendChild(this.outputDocument.importNode(this.cleanNodeProperties(selections.item(selectionIndex)), true));
            wsd.appendChild(this.outputDocument.importNode(this.cleanNodeProperties(mls.item(mlsIndex)), true));
            String checkString = String.valueOf(Integer.toString(corpIndex)) + ";" + Integer.toString(selectionIndex) + ";" + Integer.toString(mlsIndex) + ";";
            Element featureGenerators = this.outputDocument.createElement("feature_generators");
            int j = 0;
            while (j < featureGensVector.size()) {
                Element fg = featureGensVector.get(j);
                Element featureGenerator = this.outputDocument.createElement(fg.getNodeName());
                NodeList parameters = fg.getElementsByTagName("param");
                int k = 0;
                while (k < parameters.getLength()) {
                    Element parameter = this.outputDocument.createElement("param");
                    Element inParameter = (Element)parameters.item(k);
                    parameter.setAttribute("name", inParameter.getAttribute("name"));
                    NodeList paramValues = inParameter.getElementsByTagName("param_value");
                    int paramIndex = this.chooseNode(paramValues);
                    parameter.setAttribute("value", ((Element)paramValues.item(paramIndex)).getAttribute("value"));
                    featureGenerator.appendChild(parameter);
                    checkString = String.valueOf(checkString) + Integer.toString(paramIndex) + ";";
                    ++k;
                }
                featureGenerators.appendChild(featureGenerator);
                ++j;
            }
            wsd.appendChild(featureGenerators);
            if (!hs.add(checkString)) continue;
            wsdExperiment.appendChild(wsd);
            ++i;
        }
    }

    private int chooseNode(NodeList nl) {
        int[] tab = new int[nl.getLength()];
        int i = 0;
        while (i < nl.getLength()) {
            tab[i] = Integer.parseInt(((Element)nl.item(i)).getAttribute("distrib"));
            ++i;
        }
        int sum = 0;
        int i2 = 0;
        while (i2 < tab.length) {
            sum += tab[i2];
            ++i2;
        }
        Random generator = new Random();
        int rand = generator.nextInt(sum);
        int i3 = 0;
        while (i3 < tab.length) {
            if (rand < tab[i3]) {
                return i3;
            }
            rand -= tab[i3];
            ++i3;
        }
        return 0;
    }

    private Element cleanNodeProperties(Node n) {
        Element e = (Element)n.cloneNode(true);
        e.removeAttribute("distrib");
        return e;
    }

    private void generateDocumentFromMetaDescription() throws TransformerFactoryConfigurationError, ParserConfigurationException {
        DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
        this.outputDocument = docBuilder.newDocument();
        Element wsdExperiment = this.outputDocument.createElement("wsd_experiment");
        String wsdId = ((Element)this.inputDocument.getElementsByTagName("experiment_description").item(0)).getAttribute("id");
        wsdExperiment.setAttribute("id", wsdId);
        String tableName = ((Element)this.inputDocument.getElementsByTagName("experiment_description").item(0)).getAttribute("table_name");
        wsdExperiment.setAttribute("table_name", tableName);
        String wsdOverrideFlag = ((Element)this.inputDocument.getElementsByTagName("experiment_description").item(0)).getAttribute("override");
        wsdExperiment.setAttribute("override", wsdOverrideFlag);
        this.maxMethod = Integer.valueOf(this.inputDocument.getElementsByTagName("max_method").item(0).getTextContent());
        this.maxMethodTime = this.inputDocument.getElementsByTagName("max_method_time").item(0).getTextContent();
        this.outputDocument.appendChild(wsdExperiment);
        this.countConfigurations();
        if (this.maxMethod >= this.allMethodsNum) {
            this.getAllCombinations();
        } else {
            this.getProbCombinations();
        }
    }

    public static String getNewExperimentDBDescritpionFromXMLFile(String inputFile) {
        try {
            Document inputDoc = Utils.getXMLDocFromFile(inputFile);
            String tableName = inputDoc.getElementsByTagName("table_name").item(0).getTextContent();
            int exampleNum = Integer.parseInt(inputDoc.getElementsByTagName("best_limit").item(0).getTextContent());
            int generatedNum = Integer.parseInt(inputDoc.getElementsByTagName("new_exp_per_fgenerator").item(0).getTextContent());
            Document outputDoc = DatabaseHelper.getNewExperimentDescription(tableName, exampleNum, generatedNum);
            Element expOut = (Element)outputDoc.getElementsByTagName("wsd_experiment").item(0);
            Element expIn = (Element)inputDoc.getElementsByTagName("description").item(0);
            expOut.setAttribute("id", expIn.getAttribute("id"));
            expOut.setAttribute("override", "override");
            return Utils.stringFromXML(outputDoc);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getXMLFromMetaDescription(String xml_meta_description_file_name) {
        try {
            Document doc = Utils.getXMLDocFromFile(xml_meta_description_file_name);
            ExperimentDescription experimentDescription = new ExperimentDescription(doc);
            experimentDescription.generateDocumentFromMetaDescription();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(experimentDescription.outputDocument);
            transformer.transform(source, result);
            String xmlString = result.getWriter().toString();
            return xmlString;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return "";
    }

    public static void main(String[] args) throws Exception {
        String outputXml = ExperimentDescription.getXMLFromMetaDescription("experiment_meta_description_m.xml");
        Utils.saveInFile(outputXml, "gen_from_meta.xml");
        System.out.print(outputXml);
        System.out.print("END");
    }
}

