/*
 * Decompiled with CFR 0.152.
 */
package wsdde;

import java.io.StringWriter;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import wsdde.WSDMethod;
import wsdde.general.DatabaseHelper;

public class WSDExperiment
extends Vector<WSDMethod> {
    private int max_time;
    private int max_memory;
    public boolean saveModels = true;
    Document doc;
    public boolean toDB = false;
    DatabaseHelper dbh;

    public WSDExperiment(String xml_description_file) {
        try {
            DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
            this.doc = docBuilder.parse(xml_description_file);
            NodeList wsd_methods_list = this.doc.getElementsByTagName("wsd_method");
            int i = 0;
            while (i < wsd_methods_list.getLength()) {
                Element wsd_method_element = (Element)wsd_methods_list.item(i);
                this.add(new WSDMethod(wsd_method_element, this));
                ++i;
            }
        }
        catch (Exception e) {
            System.err.print("XML experiment description, parse error");
            e.printStackTrace();
        }
    }

    public void writeToDB(boolean write) {
        if (write) {
            this.toDB = write;
            this.dbh = new DatabaseHelper((Element)this.doc.getElementsByTagName("wsd_experiment").item(0));
            this.dbh.createTable();
            for (WSDMethod wsdm : this) {
                wsdm.initDBRow();
            }
        }
    }

    public String conduct() {
        for (WSDMethod wsd_method : this) {
            wsd_method.loadCorpora();
            int time = wsd_method.maxExecutionTimeMs;
            wsd_method.setSaveModels(this.saveModels);
            Thread t = new Thread(wsd_method);
            t.start();
            try {
                t.join(time);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (t.getState() == Thread.State.RUNNABLE) {
                System.out.println("timeout");
                t.stop();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                wsd_method.cleanAfterStop();
            }
            wsd_method.pushOKData();
        }
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(this.doc);
            transformer.transform(source, result);
            String xmlString = result.getWriter().toString();
            return xmlString;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        WSDExperiment myExp = new WSDExperiment("desc.xml");
        myExp.writeToDB(true);
        myExp.conduct();
    }
}

