/*
 * Decompiled with CFR 0.152.
 */
package wsdde.general;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import wsdde.WSDMethodResultRow;
import wsdde.general.Config;
import wsdde.general.Utils;

public class DatabaseHelper {
    public static final String SELECTION = "selection";
    public static final String MACHINE_LEARNING = "machine_learning";
    public static final String CORPUS_TRAINING = "corpus_training";
    public static final String CORPUS_TEST = "corpus_test";
    public static final String RESULT = "result";
    public static final String METHOD_ID = "method_id";
    public static final String EXPERIMENT_ID = "experiment_id";
    public static final String FG_PREFIX = "fg_";
    public static final String[] defaultFieldNames = new String[]{"selection", "machine_learning", "corpus_training", "corpus_test", "result", "method_id", "experiment_id"};
    private String tableName;
    private boolean overrideDBtable = false;
    private String experimentID;
    private HashMap<String, LinkedHashSet<String>> fGParameters;
    private LinkedHashSet<String> fGColumnNames;
    public String[] colNames;
    private Element XMLElement;
    private Connection dbConnection;

    public DatabaseHelper(Element xml) {
        this.XMLElement = xml;
        this.colNames = defaultFieldNames;
        try {
            this.connect();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.exit(1);
        }
        this.initFromXML();
    }

    public DatabaseHelper(String tblName) {
        this.tableName = tblName;
        this.overrideDBtable = false;
        try {
            this.connect();
            this.initFromTableName();
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void initFromTableName() throws SQLException {
        Vector<String> tmpCols = new Vector<String>();
        this.fGColumnNames = new LinkedHashSet();
        DatabaseMetaData meta = this.dbConnection.getMetaData();
        ResultSet rsColumns = meta.getColumns(null, null, this.tableName, null);
        while (rsColumns.next()) {
            String columnName = rsColumns.getString("COLUMN_NAME");
            if (columnName.contains(FG_PREFIX)) {
                this.fGColumnNames.add(columnName);
                continue;
            }
            tmpCols.add(columnName);
        }
        this.colNames = new String[tmpCols.size()];
        int i = 0;
        while (i < tmpCols.size()) {
            this.colNames[i] = (String)tmpCols.get(i);
            ++i;
        }
    }

    public void setExperimentID(String newID) {
        this.experimentID = newID;
    }

    public void setExperimentID(int newID) {
        this.experimentID = Integer.toString(newID);
    }

    public String getExperimentID() {
        return this.experimentID;
    }

    public LinkedHashSet<String> getFGColumnNames() {
        return this.fGColumnNames;
    }

    private String getDBType(String fieldName) {
        if (fieldName.equals(RESULT)) {
            return " double ";
        }
        if (fieldName.equals(SELECTION) | fieldName.equals(MACHINE_LEARNING)) {
            return " TEXT ";
        }
        return " char(200) ";
    }

    private void initFromXML() {
        this.tableName = this.XMLElement.getAttribute("table_name");
        String overrideStr = this.XMLElement.getAttribute("override");
        this.setExperimentID(this.XMLElement.getAttribute("id"));
        if (overrideStr.equals("1") || Boolean.parseBoolean(overrideStr)) {
            this.overrideDBtable = true;
        }
        this.fGParameters = new HashMap();
        this.fGColumnNames = new LinkedHashSet();
        Element fGenerators = (Element)this.XMLElement.getElementsByTagName("feature_generators").item(0);
        Vector<Element> featureGensVector = Utils.getChildElementsVector(fGenerators);
        int i = 0;
        while (i < featureGensVector.size()) {
            Element fg = featureGensVector.get(i);
            LinkedHashSet<String> hs = new LinkedHashSet<String>();
            String methodName = fg.getNodeName();
            NodeList params = fg.getElementsByTagName("param");
            int j = 0;
            while (j < params.getLength()) {
                String paramName = ((Element)params.item(j)).getAttribute("name");
                hs.add(paramName);
                this.fGColumnNames.add(FG_PREFIX + methodName + "_" + paramName);
                ++j;
            }
            this.fGParameters.put(methodName, hs);
            ++i;
        }
    }

    private void connect() throws ClassNotFoundException, SQLException {
        String driver = "";
        if (Config.Settings.DB_USED.value().equals("mysql")) {
            Class.forName("com.mysql.jdbc.Driver");
            driver = "mysql";
        }
        String url = "jdbc:" + driver + "://" + Config.property(Config.Settings.DB_SERVER) + ":" + Config.property(Config.Settings.DB_PORT) + "/" + Config.property(Config.Settings.DB_NAME);
        this.dbConnection = DriverManager.getConnection(url, Config.property(Config.Settings.DB_USER), Config.property(Config.Settings.DB_PASS));
    }

    public void createTable() {
        block5: {
            PreparedStatement stmt;
            String sql;
            if (this.overrideDBtable) {
                sql = "DROP TABLE " + this.tableName;
                try {
                    stmt = this.dbConnection.prepareStatement(sql);
                    stmt.execute();
                }
                catch (SQLException stmt2) {
                    // empty catch block
                }
            }
            sql = this.getSQLCreateTableStatement();
            try {
                stmt = this.dbConnection.prepareStatement(sql);
                stmt.execute();
            }
            catch (SQLException e) {
                System.out.println(e.getMessage());
                if (!this.overrideDBtable) break block5;
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    public Vector<WSDMethodResultRow> getBestResultsVector() throws SQLException {
        return this.getResultsVector(this.getSQLBestResultsQuery());
    }

    public Vector<WSDMethodResultRow> getResultsVector(String sql) throws SQLException {
        Vector<WSDMethodResultRow> result = new Vector<WSDMethodResultRow>();
        PreparedStatement pstmt = this.dbConnection.prepareStatement(sql);
        ResultSet rs = pstmt.executeQuery();
        while (rs.next()) {
            WSDMethodResultRow wsdmrr = new WSDMethodResultRow(rs, this);
            result.add(wsdmrr);
        }
        return result;
    }

    public Document getXMLDoc(Vector<WSDMethodResultRow> rows) {
        Document doc = Utils.createDomDocument();
        Element wsdExperimentElement = doc.createElement("wsd_experiment");
        wsdExperimentElement.setAttribute("table_name", this.tableName);
        int i = 0;
        while (i < rows.size()) {
            Element el = rows.get(i).generateOutputXMLNode();
            wsdExperimentElement.appendChild(doc.importNode(el, true));
            ++i;
        }
        doc.appendChild(wsdExperimentElement);
        return doc;
    }

    public String getSQLBestResultsQuery() {
        String sql = "SELECT ";
        int i = 0;
        while (i < this.colNames.length) {
            if (i != 0) {
                sql = String.valueOf(sql) + ", ";
            }
            sql = String.valueOf(sql) + this.colNames[i];
            ++i;
        }
        for (String columName : this.fGColumnNames) {
            sql = String.valueOf(sql) + ", `" + columName + "`";
        }
        sql = String.valueOf(sql) + " FROM " + this.tableName + " A " + "WHERE " + RESULT + "> (SELECT " + RESULT + " FROM " + this.tableName + " WHERE " + CORPUS_TRAINING + " = A." + CORPUS_TRAINING + " " + "ORDER BY " + RESULT + " DESC LIMIT 5,1) " + "ORDER BY " + CORPUS_TRAINING + ", " + RESULT;
        return sql;
    }

    public String getSQLCreateTableStatement() {
        String statement = "";
        statement = String.valueOf(statement) + "CREATE TABLE " + this.tableName + " (" + "id int(10) unsigned NOT NULL AUTO_INCREMENT, ";
        int i = 0;
        while (i < this.colNames.length) {
            statement = String.valueOf(statement) + this.colNames[i] + this.getDBType(this.colNames[i]) + ", ";
            ++i;
        }
        String paramsSubstatement = "";
        for (String columnName : this.fGColumnNames) {
            paramsSubstatement = String.valueOf(paramsSubstatement) + "`" + columnName + "` integer, ";
        }
        statement = String.valueOf(statement) + paramsSubstatement;
        statement = String.valueOf(statement) + "PRIMARY KEY (id) )";
        return statement;
    }

    public String[] getColNames() {
        return this.colNames;
    }

    public void insertWSDMethodResultRow(WSDMethodResultRow row) throws SQLException {
        String sql = "INSERT INTO " + this.tableName + " (";
        int i = 0;
        while (i < this.colNames.length) {
            if (i != 0) {
                sql = String.valueOf(sql) + ", ";
            }
            sql = String.valueOf(sql) + this.colNames[i];
            ++i;
        }
        for (String columName : this.fGColumnNames) {
            sql = String.valueOf(sql) + ", `" + columName + "`";
        }
        sql = String.valueOf(sql) + ")";
        sql = String.valueOf(sql) + "VALUES(";
        int numOfColumns = this.colNames.length + this.fGColumnNames.size();
        int i2 = 1;
        while (i2 <= numOfColumns) {
            sql = String.valueOf(sql) + (i2 != numOfColumns ? "?, " : "?)");
            ++i2;
        }
        PreparedStatement pstmt = this.dbConnection.prepareStatement(sql);
        int paramNum = 0;
        int i3 = 0;
        while (i3 < this.colNames.length) {
            pstmt.setString(++paramNum, row.getMethodParamValue(this.colNames[i3]));
            ++i3;
        }
        for (String columName : this.fGColumnNames) {
            pstmt.setString(++paramNum, row.fGParamValues.get(columName));
        }
        pstmt.execute();
    }

    public static String getXMLFromTable(String tableName) throws SQLException {
        String sql = "select * from " + tableName;
        DatabaseHelper dbh = new DatabaseHelper(tableName);
        Vector<WSDMethodResultRow> rows = dbh.getResultsVector(sql);
        Document doc = dbh.getXMLDoc(rows);
        return Utils.stringFromXML(doc);
    }

    public static Document getNewExperimentDescription(String tableName, int exampleNum, int generatedNum) {
        try {
            DatabaseHelper dbh = new DatabaseHelper(tableName);
            String sql = "SELECT * FROM " + tableName + " ORDER BY " + RESULT + " DESC LIMIT " + Integer.toString(exampleNum);
            Vector<WSDMethodResultRow> rows = dbh.getResultsVector(sql);
            Vector<WSDMethodResultRow> generatedRows = new Vector<WSDMethodResultRow>();
            int i = 0;
            while (i < rows.size()) {
                Vector<WSDMethodResultRow> tmp = rows.get(i).getSimilarRows(generatedNum);
                generatedRows.addAll(tmp);
                ++i;
            }
            Document doc = dbh.getXMLDoc(generatedRows);
            return doc;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws SQLException {
    }
}

