/*
 * Decompiled with CFR 0.152.
 */
package ipipan.poliqarp.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import com.jgoodies.looks.plastic.theme.ExperienceBlue;
import ipipan.poliqarp.connection.PoliqarpConnection;
import ipipan.poliqarp.gui.CSVResultWriter;
import ipipan.poliqarp.gui.ConfigDialog;
import ipipan.poliqarp.gui.Configuration;
import ipipan.poliqarp.gui.ContextArea;
import ipipan.poliqarp.gui.CorpusFileFilter;
import ipipan.poliqarp.gui.ErrorTranslator;
import ipipan.poliqarp.gui.HTMLResultWriter;
import ipipan.poliqarp.gui.MetaDataConstraintSet;
import ipipan.poliqarp.gui.MetaDataTable;
import ipipan.poliqarp.gui.MultifunctionButton;
import ipipan.poliqarp.gui.MultilingualEntity;
import ipipan.poliqarp.gui.MultilingualMenuItem;
import ipipan.poliqarp.gui.PlainTxtResultWriter;
import ipipan.poliqarp.gui.PoliqarpIconFactory;
import ipipan.poliqarp.gui.PoliqarpMenuBar;
import ipipan.poliqarp.gui.ResultTable;
import ipipan.poliqarp.gui.ResultWriter;
import ipipan.poliqarp.gui.SaveFileFilter;
import ipipan.poliqarp.gui.StatusLine;
import ipipan.poliqarp.gui.StatusPanel;
import ipipan.poliqarp.logic.Corpus;
import ipipan.poliqarp.logic.CorpusNotOpenedException;
import ipipan.poliqarp.logic.CorpusStatistics;
import ipipan.poliqarp.logic.Query;
import ipipan.poliqarp.logic.QueryException;
import ipipan.poliqarp.stat.StatQueryException;
import ipipan.poliqarp.stat.Tagset;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public final class Application
extends WindowAdapter {
    private Configuration config;
    private JFrame mainFrame;
    private Set<MultilingualEntity> multilingual = new HashSet<MultilingualEntity>();
    private PoliqarpMenuBar menuBar;
    private StatusPanel statusPanel;
    private JComboBox queryField;
    private MultifunctionButton executeButton;
    private ResultTable resultTable;
    private MetaDataTable metaTable;
    private ContextArea contextArea;
    private JScrollPane bottomPane;
    private ErrorTranslator errorTranslator;
    private boolean contextAreaVisible;
    private ButtonActionListener bal;
    private PoliqarpConnection connection;
    private Corpus corpus;
    private MetaDataConstraintSet constraints;
    private Query query;
    private Timer timer;
    private JPopupMenu sortMenu;
    private int popupSortColumn;
    private File lastSaveDir = null;
    private Tagset tagset;
    private static final int MAX_HISTORY_SIZE = 100;
    private static final String configFileName = ".poliqarp.cfg";
    private static final String historyFileName = ".poliqarp.his";
    private static final String[] availableEncodings = new String[]{"utf-8", "iso-8859-2", "windows-1250"};

    private void sortResults(int n, boolean bl, boolean bl2) {
        if (this.resultTable.getModel().isStatistical()) {
            this.resultTable.getModel().sortStat(n, bl2);
            return;
        }
        if (this.query.getHeader().length == 3 && n >= 1) {
            ++n;
        }
        this.resultTable.setContentChangingEnabled(false);
        this.statusPanel.setButtonsEnabled(false);
        this.queryField.setEnabled(false);
        this.executeButton.setEnabled(false);
        this.statusPanel.setState(StatusLine.State.SORTING, null, null, this.config);
        this.query.getMatchList().sort(n, bl, bl2, new Runnable(){

            public void run() {
                Application.this.resultTable.setContentChangingEnabled(true);
                Application.this.statusPanel.setButtonsEnabled(true);
                Application.this.queryField.setEnabled(true);
                Application.this.executeButton.setEnabled(true);
                Application.this.statusPanel.setState(StatusLine.State.RESULTS, null, null, Application.this.config);
                Application.this.resultTable.getModel().refreshResults();
            }
        });
    }

    private void sortLetter(char c) {
        this.resultTable.setContentChangingEnabled(false);
        this.statusPanel.setButtonsEnabled(false);
        this.queryField.setEnabled(false);
        this.executeButton.setEnabled(false);
        this.statusPanel.setState(StatusLine.State.SORTING, null, null, this.config);
        this.query.getMatchList().sortLetter(c, new Runnable(){

            public void run() {
                Application.this.resultTable.setContentChangingEnabled(true);
                Application.this.statusPanel.setButtonsEnabled(true);
                Application.this.queryField.setEnabled(true);
                Application.this.executeButton.setEnabled(true);
                Application.this.statusPanel.setState(StatusLine.State.RESULTS, null, null, Application.this.config);
                Application.this.resultTable.getModel().refreshResults();
            }
        });
    }

    public void initConfig() {
        try {
            this.config = new Configuration(configFileName);
        }
        catch (Exception exception) {
            this.config = new Configuration();
            this.config.setLanguage("English");
            this.config.setMissingToDefault();
        }
    }

    public void updateLanguage() {
        for (MultilingualEntity multilingualEntity : this.multilingual) {
            multilingualEntity.updateLanguage(this.config);
        }
    }

    public Configuration getConfig() {
        return this.config;
    }

    public Corpus getCorpus() {
        return this.corpus;
    }

    public void toggleContextVisible() {
        this.contextAreaVisible = !this.contextAreaVisible;
        this.bottomPane.setViewportView(this.contextAreaVisible ? this.contextArea : this.metaTable);
        this.statusPanel.updateLanguage(this.config);
    }

    public void showAbout() {
        StringBuilder stringBuilder = new StringBuilder(this.config.getComponentName("TEXT_ABOUT"));
        if (this.connection != null) {
            stringBuilder.append(this.config.getComponentName("TEXT_SERVER_VERSION"));
            stringBuilder.append(this.connection.getServerVersion());
        }
        JOptionPane.showMessageDialog(this.mainFrame, stringBuilder.toString(), this.config.getComponentName("TEXT_ABOUTTITLE"), 1);
    }

    public boolean isConnected() {
        return this.connection != null;
    }

    public void showError(String string) {
        JOptionPane.showMessageDialog(this.mainFrame, this.config.getComponentName("ERR_" + string), this.config.getComponentName("TEXT_ERROR"), 0);
    }

    public void showCustomError(String string) {
        JOptionPane.showMessageDialog(this.mainFrame, string, this.config.getComponentName("TEXT_ERROR"), 0);
    }

    private void openCorpus(String string) {
        final String string2 = string;
        this.config.getMRU().add(string2);
        this.menuBar.updateMRU();
        this.tagset = new Tagset(string2);
        try {
            if (this.corpus != null) {
                this.corpus.close();
            }
            this.corpus = new Corpus(this.connection, string2, new Runnable(){

                public void run() {
                    Application.this.statusPanel.disableProgress();
                    if (Application.this.corpus.getState() == Corpus.State.OPENED) {
                        Application.this.statusPanel.setState(StatusLine.State.CURRENT, string2, null, Application.this.config);
                        Application.this.menuBar.activateCorpusOptions(true);
                        Application.this.activateCorpusWidgets(true);
                        Application.this.constraints = new MetaDataConstraintSet(Application.this.corpus);
                    } else {
                        Application.this.statusPanel.setState(StatusLine.State.NOCURRENT, null, null, Application.this.config);
                        Application.this.resultTable.getModel().clear();
                        Application.this.menuBar.activateCorpusOptions(false);
                        Application.this.activateCorpusWidgets(false);
                        if (new File(string2 + ".poliqarp.corpus.image").exists()) {
                            String string = Application.this.config.getComponentName("ERR_OPEN");
                            try {
                                string = Application.this.corpus.getLastError();
                            }
                            catch (CorpusNotOpenedException corpusNotOpenedException) {
                                // empty catch block
                            }
                            Application.this.showCustomError(Application.this.errorTranslator.translate(string));
                        } else {
                            Application.this.showError("NOCORPUS");
                        }
                        Application.this.corpus = null;
                    }
                }
            });
            this.statusPanel.setState(StatusLine.State.LOADING, string2, null, this.config);
            this.statusPanel.enableProgress(this.corpus);
        }
        catch (CorpusNotOpenedException corpusNotOpenedException) {
            if (new File(string + ".poliqarp.corpus.image").exists()) {
                this.showError("OPEN");
            }
            this.showError("NOCORPUS");
        }
    }

    public void createOpenDialog() {
        if (this.connection == null) {
            this.showError("NOTCONNECTED");
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        CorpusFileFilter corpusFileFilter = new CorpusFileFilter(this.config);
        jFileChooser.addChoosableFileFilter(corpusFileFilter);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileFilter(corpusFileFilter);
        jFileChooser.setFileHidingEnabled(false);
        if (jFileChooser.showOpenDialog(this.mainFrame) == 0) {
            File file = jFileChooser.getSelectedFile();
            if (file.exists()) {
                String string = file.getAbsolutePath();
                String string2 = string.substring(0, string.length() - CorpusFileFilter.extensionLength);
                this.openCorpus(string2);
            } else {
                this.showError("NOCORPUS");
            }
        }
    }

    public void createSaveDialog() {
        if (this.connection == null || this.query == null) {
            this.showError("NOTCONNECTED");
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        JComboBox<String> jComboBox = new JComboBox<String>(availableEncodings);
        SaveFileFilter saveFileFilter = new SaveFileFilter(this.config, ".*\\.html?", ".html", "TEXT_HTML");
        SaveFileFilter saveFileFilter2 = new SaveFileFilter(this.config, ".*\\.txt", ".txt", "TEXT_TXT");
        SaveFileFilter saveFileFilter3 = new SaveFileFilter(this.config, ".*\\.csv", ".csv", "TEXT_CSV");
        jFileChooser.addChoosableFileFilter(saveFileFilter2);
        jFileChooser.addChoosableFileFilter(saveFileFilter3);
        jFileChooser.addChoosableFileFilter(saveFileFilter);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileFilter(saveFileFilter2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new FormLayout("2dlu, default", "default:grow, default, default:grow"));
        jPanel.add(jComboBox, new CellConstraints(2, 2));
        jFileChooser.setAccessory(jPanel);
        if (this.lastSaveDir != null) {
            jFileChooser.setCurrentDirectory(this.lastSaveDir);
        }
        if (jFileChooser.showSaveDialog(this.mainFrame) == 0) {
            File file = jFileChooser.getSelectedFile();
            String string = file.getAbsolutePath();
            SaveFileFilter saveFileFilter4 = (SaveFileFilter)jFileChooser.getFileFilter();
            ResultWriter resultWriter = null;
            if (file.isDirectory() || !saveFileFilter4.accept(file)) {
                string = string + saveFileFilter4.getExtension();
                file = new File(string);
            }
            String string2 = (String)jComboBox.getSelectedItem();
            if (saveFileFilter.accept(file)) {
                resultWriter = new HTMLResultWriter(this.config);
            }
            if (saveFileFilter2.accept(file)) {
                resultWriter = new PlainTxtResultWriter(this.config);
            }
            if (saveFileFilter3.accept(file)) {
                resultWriter = new CSVResultWriter(this.config);
            }
            if (resultWriter == null) {
                return;
            }
            final ResultWriter resultWriter2 = resultWriter;
            final String string3 = string;
            final Query query = this.query;
            final String string4 = string2;
            new Thread(){

                public void run() {
                    Application.this.executeButton.setEnabled(false);
                    Application.this.statusPanel.setState(StatusLine.State.WRITERESULTS, null, null, Application.this.config);
                    try {
                        resultWriter2.writeResults(string3, query, string4, null);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    Application.this.statusPanel.setState(StatusLine.State.RESULTS, null, null, Application.this.config);
                    Application.this.executeButton.setEnabled(true);
                }
            }.start();
            this.lastSaveDir = file.getParentFile();
        }
    }

    public void openMRU(int n) {
        this.openCorpus(this.config.getMRU().get(n));
    }

    public void createConfigDialog() {
        new ConfigDialog(this.mainFrame, this).launch();
    }

    private void launchQuery() {
        if (this.query != null && this.query.isRunning()) {
            return;
        }
        try {
            String string;
            String string2 = (String)this.queryField.getEditor().getItem();
            string2 = string2.trim();
            this.addHistory(string2);
            int n = string2.indexOf(" group by ");
            if (n != -1) {
                string = string2.substring(n + 10);
                string2 = string2.substring(0, n);
            } else {
                string = null;
            }
            if (this.query != null && string != null && string2.equals(this.query.toString())) {
                try {
                    this.query.getMatchList().createCounter(string, this.tagset);
                }
                catch (StatQueryException statQueryException) {
                    this.showError("STATQUERY");
                    return;
                }
                this.resultTable.getModel().setData(this.query, this.query.getMatchList(), this.config);
                this.resultTable.getModel().clear();
                this.runMatchCounter();
                return;
            }
            String string3 = this.constraints.getQueryConstraint();
            if (string3 != null && (n = string2.indexOf("meta")) == -1) {
                string2 = string2 + " meta " + string3;
            }
            this.timer = new Timer(200, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Application.this.query.getMatchList().updateCount();
                    Application.this.resultTable.getModel().updateContents();
                }
            });
            this.query = new Query(this.connection, string2);
            try {
                this.query.getMatchList().createCounter(string, this.tagset);
            }
            catch (StatQueryException statQueryException) {
                this.showError("STATQUERY");
                return;
            }
            if (string != null) {
                this.statusPanel.setState(StatusLine.State.MATCHSEARCHING, null, null, this.config);
            } else {
                this.statusPanel.setState(StatusLine.State.EXECUTING, null, null, this.config);
            }
            this.resultTable.getModel().setData(this.query, this.query.getMatchList(), this.config);
            this.resultTable.getModel().clear();
            this.query.launch(new Runnable(){

                public void run() {
                    Application.this.timer.stop();
                    if (Application.this.query.getMatchList().getCounter() != null) {
                        Application.this.runMatchCounter();
                    }
                    Application.this.statusPanel.disableProgress();
                    Application.this.statusPanel.setState(StatusLine.State.RESULTS, null, null, Application.this.config);
                    Application.this.resultTable.getModel().updateContents();
                    Application.this.menuBar.activateQueryOptions(true);
                    Application.this.executeButton.setFunction(0);
                    Application.this.executeButton.updateLanguage(Application.this.config);
                    Configuration configuration = Application.this.config;
                    Application.this.config;
                    String string = configuration.getConfigItem("sort-by");
                    if (!string.equals("")) {
                        Application.this.sortLetter(string.charAt(0));
                    }
                }
            });
            this.executeButton.setFunction(1);
            this.executeButton.updateLanguage(this.config);
            this.statusPanel.enableProgress(this.query);
            this.timer.start();
        }
        catch (QueryException queryException) {
            this.query = null;
            this.resultTable.getModel().clear();
            String string = null;
            try {
                string = this.corpus.getLastError();
            }
            catch (CorpusNotOpenedException corpusNotOpenedException) {
                // empty catch block
            }
            if (string == null) {
                string = "Incorrect or incomplete query.";
            }
            this.showCustomError(this.errorTranslator.translate(string));
            this.menuBar.activateQueryOptions(false);
        }
    }

    private void runMatchCounter() {
        new Thread(){

            public void run() {
                try {
                    Application.this.executeButton.setEnabled(false);
                    Application.this.statusPanel.setState(StatusLine.State.MATCHCOUNTING, null, null, Application.this.config);
                    Application.this.statusPanel.enableProgress(Application.this.query.getMatchList().getCounter());
                    Application.this.query.getMatchList().runCounter();
                    Application.this.statusPanel.disableProgress();
                    Application.this.statusPanel.setState(StatusLine.State.RESULTS, null, null, Application.this.config);
                    Application.this.executeButton.setEnabled(true);
                    Application.this.resultTable.getModel().updateContents();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    private void cancelQuery() {
        if (this.query == null || !this.query.isRunning()) {
            return;
        }
        try {
            this.query.abort();
            this.timer.stop();
            this.query = null;
            this.statusPanel.disableProgress();
            this.statusPanel.setState(StatusLine.State.CURRENT, this.corpus.getName(), null, this.config);
            this.resultTable.getModel().clear();
            this.menuBar.activateQueryOptions(false);
            this.executeButton.setFunction(0);
            this.executeButton.updateLanguage(this.config);
        }
        catch (QueryException queryException) {
            queryException.printStackTrace();
        }
    }

    private void writeHistory(String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-8")));
            for (int i = 0; i < this.queryField.getItemCount(); ++i) {
                printWriter.println(this.queryField.getItemAt(i).toString());
            }
            printWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readHistory(String string) {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
            while ((string2 = bufferedReader.readLine()) != null) {
                this.queryField.addItem(string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getStatsDescription(int n) {
        return this.config.getComponentName("TEXT_CORPUS_STATS_" + n);
    }

    public void showCorpusStatistics() {
        try {
            CorpusStatistics corpusStatistics = this.corpus.getStatistics();
            String string = this.getStatsDescription(1) + " " + this.corpus.getName() + "\n\n" + this.getStatsDescription(2) + " " + corpusStatistics.getSegments() + "\n" + this.getStatsDescription(3) + " " + corpusStatistics.getTypes() + "\n" + this.getStatsDescription(4) + " " + corpusStatistics.getLemmata() + "\n" + this.getStatsDescription(5) + " " + corpusStatistics.getTags() + "\n";
            JOptionPane.showMessageDialog(this.mainFrame, string, this.config.getComponentName("TEXT_CORPUS_STATS_TITLE"), 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addEditorListeners() {
        final JTextField jTextField = (JTextField)this.queryField.getEditor().getEditorComponent();
        jTextField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                jTextField.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
            }
        });
        jTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    Application.this.executeButton.doClick();
                }
            }
        });
    }

    private void createQueryPanel() {
        this.queryField = new JComboBox();
        this.queryField.setEditable(true);
        this.queryField.setEnabled(false);
        this.mainFrame.add((Component)this.queryField, new CellConstraints(2, 2));
        this.executeButton = new MultifunctionButton("EXECUTE", 2);
        this.multilingual.add(this.executeButton);
        this.executeButton.setEnabled(false);
        this.bal = new ButtonActionListener();
        this.executeButton.addActionListener(this.bal);
        this.mainFrame.add((Component)this.executeButton, new CellConstraints(4, 2));
    }

    private void activateCorpusWidgets(boolean bl) {
        this.queryField.setEnabled(bl);
        this.executeButton.setEnabled(bl);
        this.contextArea.setEnabled(bl);
    }

    private void createSplitPane() {
        this.resultTable = new ResultTable(this);
        this.resultTable.getModel().setData(null, null, this.config);
        this.multilingual.add(this.resultTable);
        this.contextArea = new ContextArea();
        this.contextArea.setEnabled(false);
        this.metaTable = new MetaDataTable();
        this.multilingual.add(this.metaTable);
        this.bottomPane = new JScrollPane(this.contextArea);
        this.contextAreaVisible = true;
        this.resultTable.addContextSelectionListener(this.contextArea, this.metaTable);
        this.resultTable.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                if (((ResultTable)jTableHeader.getTable()).getModel().isStatistical()) {
                    return;
                }
                if (mouseEvent.getButton() == 3 && mouseEvent.isPopupTrigger() && Application.this.query != null && !Application.this.query.isRunning()) {
                    TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
                    int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                    Application.this.popupSortColumn = tableColumnModel.getColumn(n).getModelIndex();
                    Application.this.sortMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.mousePressed(mouseEvent);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 1 || Application.this.query == null || Application.this.query.isRunning()) {
                    return;
                }
                JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                int n2 = tableColumnModel.getColumn(n).getModelIndex();
                Application.this.sortResults(n2, !mouseEvent.isShiftDown(), true);
            }
        });
        JSplitPane jSplitPane = new JSplitPane(0, new JScrollPane(this.resultTable), this.bottomPane);
        jSplitPane.setDividerLocation(250);
        this.mainFrame.add((Component)jSplitPane, new CellConstraints(2, 4, 3, 1));
    }

    private void createStatusPanel() {
        this.statusPanel = new StatusPanel(this);
        this.multilingual.add(this.statusPanel);
        this.resultTable.getModel().addResultEventListener(this.statusPanel);
        this.mainFrame.add((Component)this.statusPanel, new CellConstraints(2, 6, 3, 1));
    }

    public void connectToServer() {
        try {
            this.connection = new PoliqarpConnection(this.config.getConfigItem("server"), Integer.parseInt(this.config.getConfigItem("port")));
            this.config.updateConfig(this.connection);
            this.menuBar.disableConnectionCmd();
        }
        catch (Exception exception) {
            this.showError("NOCONNECT");
        }
    }

    private void createMMI(String string, int n) {
        MultilingualMenuItem multilingualMenuItem = new MultilingualMenuItem(string);
        multilingualMenuItem.setActionCommand("" + n);
        multilingualMenuItem.addActionListener(this.bal);
        this.multilingual.add(multilingualMenuItem);
        this.sortMenu.add(multilingualMenuItem);
    }

    private void createSortMenu() {
        this.sortMenu = new JPopupMenu();
        this.createMMI("SORT_ALPHA_ASC", 0);
        this.createMMI("SORT_ALPHA_DESC", 1);
        this.createMMI("SORT_ATERGO_ASC", 2);
        this.createMMI("SORT_ATERGO_DESC", 3);
    }

    public void updateSizes() {
        float f = Integer.parseInt(this.config.getConfigItem("gui-font-size"));
        ResizableFontTheme resizableFontTheme = new ResizableFontTheme(f);
        PlasticLookAndFeel.setPlasticTheme((PlasticTheme)resizableFontTheme);
        try {
            UIManager.setLookAndFeel((LookAndFeel)new PlasticXPLookAndFeel());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.resultTable.setRowHeight(resizableFontTheme.getTableRowHeight());
        this.metaTable.setRowHeight(resizableFontTheme.getTableRowHeight());
        SwingUtilities.updateComponentTreeUI(this.mainFrame);
        this.metaTable.updateUI();
        SwingUtilities.updateComponentTreeUI(this.sortMenu);
        this.addEditorListeners();
        this.contextArea.setSize(f * 5.0f / 4.0f);
    }

    private void createAndShowGUI() {
        PlasticLookAndFeel.setPlasticTheme((PlasticTheme)new ResizableFontTheme(10.0f));
        try {
            UIManager.setLookAndFeel((LookAndFeel)new PlasticXPLookAndFeel());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mainFrame = new JFrame("Poliqarp");
        this.mainFrame.setIconImage(PoliqarpIconFactory.loadIcon("appicon").getImage());
        this.mainFrame.addWindowListener(this);
        this.mainFrame.setDefaultCloseOperation(3);
        this.mainFrame.setLayout((LayoutManager)new FormLayout("2dlu, d:grow, 2dlu, default, 2dlu", "2dlu, min, 2dlu, fill:default:grow, 2dlu, min, 2dlu"));
        this.initConfig();
        this.errorTranslator = new ErrorTranslator();
        this.multilingual.add(this.errorTranslator);
        this.menuBar = new PoliqarpMenuBar(this);
        this.multilingual.add(this.menuBar);
        this.mainFrame.setJMenuBar(this.menuBar.getBar());
        this.createQueryPanel();
        this.createSplitPane();
        this.createStatusPanel();
        this.createSortMenu();
        this.updateLanguage();
        this.updateSizes();
        this.readHistory(historyFileName);
        this.mainFrame.setSize(640, 480);
        this.mainFrame.setVisible(true);
        this.connectToServer();
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                new Application().createAndShowGUI();
            }
        });
    }

    private void addHistory(String string) {
        for (int i = 0; i < this.queryField.getItemCount(); ++i) {
            if (!this.queryField.getItemAt(i).equals(string)) continue;
            this.queryField.removeItemAt(i);
        }
        if (this.queryField.getItemCount() == 100) {
            this.queryField.removeItemAt(99);
        }
        this.queryField.insertItemAt(string, 0);
        this.queryField.setSelectedIndex(0);
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.exitCleanup();
    }

    public void updateConfig() {
        if (this.isConnected()) {
            this.config.updateConfig(this.connection);
            this.resultTable.getModel().refreshResults();
        }
    }

    public void exitCleanup() {
        try {
            this.config.writeConfig(configFileName);
            this.writeHistory(historyFileName);
            if (this.corpus != null) {
                this.corpus.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MetaDataConstraintSet getConstraints() {
        return this.constraints;
    }

    private class ResizableFontTheme
    extends ExperienceBlue {
        private float fontSize;

        public ResizableFontTheme(float f) {
            this.fontSize = f;
        }

        public FontUIResource getUserTextFont() {
            return new FontUIResource(super.getUserTextFont().deriveFont(this.fontSize));
        }

        public int getTableRowHeight() {
            return (int)(this.fontSize * 16.0f / 11.0f);
        }
    }

    private class ButtonActionListener
    implements ActionListener {
        private ButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == Application.this.executeButton) {
                switch (Application.this.executeButton.getFunction()) {
                    case 0: {
                        Application.this.launchQuery();
                        break;
                    }
                    case 1: {
                        Application.this.cancelQuery();
                    }
                }
            } else {
                int n = Integer.parseInt(actionEvent.getActionCommand());
                Application.this.sortResults(Application.this.popupSortColumn, n == 0 || n == 1, n == 0 || n == 2);
            }
        }
    }
}

