/*
 * Decompiled with CFR 0.152.
 */
package ipipan.poliqarp.gui;

import ipipan.poliqarp.gui.Configuration;
import ipipan.poliqarp.gui.MultilingualEntity;
import ipipan.poliqarp.util.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorTranslator
implements MultilingualEntity {
    private Map<String, List<Pair<String, String>>> data = new HashMap<String, List<Pair<String, String>>>();
    private List<Pair<String, String>> current;

    @Override
    public void updateLanguage(Configuration configuration) {
        String string = "en";
        String string2 = configuration.getConfigItem("language");
        if (string2.toLowerCase().equals("polish")) {
            string = "pl";
        }
        this.current = this.data.get(string);
        if (this.current == null) {
            try {
                this.current = this.readData(string);
                this.data.put(string, this.current);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String translate(String string) {
        if (this.current == null) {
            return string;
        }
        for (Pair<String, String> pair : this.current) {
            string = string.replace(pair.first(), pair.second());
        }
        return string + ".";
    }

    private List<Pair<String, String>> readData(String string) throws IOException {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("errors/errors_" + string + ".txt"), "UTF-8"));
        LinkedList<Pair<String, String>> linkedList = new LinkedList<Pair<String, String>>();
        Pattern pattern = Pattern.compile("\"([^\"]+)\"\\s*:\\s*\"([^\"]+)\"");
        while ((string2 = bufferedReader.readLine()) != null) {
            Matcher matcher = pattern.matcher(string2);
            if (!matcher.matches()) continue;
            linkedList.add(new Pair<String, String>(matcher.group(1), matcher.group(2)));
        }
        return linkedList;
    }
}

