/*
 * Decompiled with CFR 0.152.
 */
package ipipan.poliqarp.gui;

import ipipan.poliqarp.gui.Configuration;
import ipipan.poliqarp.gui.ResultWriter;
import ipipan.poliqarp.logic.Match;
import ipipan.poliqarp.logic.Query;
import ipipan.poliqarp.util.PoliqarpUtilities;

public class HTMLResultWriter
extends ResultWriter {
    public HTMLResultWriter(Configuration configuration) {
        super(configuration);
    }

    protected void writeHeader(Query query, String string) {
        String string2 = PoliqarpUtilities.htmlSpecialChars(query.toString());
        this.writer.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
        this.writer.println("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">");
        this.writer.println("  <head>");
        this.writer.println("    <meta http-equiv=\"Content-type\" content=\"text/html; charset=" + string + "\" />");
        this.writer.println("    <meta name=\"Generator\" content=\"Poliqarp\" />");
        this.writer.println("    <title>" + this.cfg.getComponentName("TEXT_RESULTS") + " " + string2 + "</title>");
        this.writer.println("  </head>");
        this.writer.println("  <body>");
        this.writer.println("    <h1>" + this.cfg.getComponentName("TEXT_RESULTS") + " <tt>" + string2 + "</tt></h1>");
        this.writer.println("    <table>");
        this.writer.println("      <tr>");
        for (String string3 : this.colHeaders) {
            this.writer.println("        <th>" + string3 + "</th>");
        }
        this.writer.println("      </tr>");
    }

    protected void writeMatch(Match match) {
        this.writer.println("      <tr>");
        for (int i = 0; i < this.numCols; ++i) {
            this.writer.println("        <td>" + match.getCell(i).toHTML(this.cfg) + "</td>");
        }
        this.writer.println("      </tr>");
    }

    protected void writeFooter() {
        this.writer.println("    </table>");
        this.writer.println("  </body>");
        this.writer.println("</html>");
    }
}

