/*
 * Decompiled with CFR 0.152.
 */
package ipipan.poliqarp.logic;

import ipipan.poliqarp.connection.AsyncHandler;
import ipipan.poliqarp.connection.Message;
import ipipan.poliqarp.connection.PoliqarpConnection;
import ipipan.poliqarp.logic.Match;
import ipipan.poliqarp.logic.MatchIterator;
import ipipan.poliqarp.logic.MetaData;
import ipipan.poliqarp.logic.Query;
import ipipan.poliqarp.logic.WideContext;
import ipipan.poliqarp.stat.MatchCounter;
import ipipan.poliqarp.stat.StatIterator;
import ipipan.poliqarp.stat.StatQueryException;
import ipipan.poliqarp.stat.Tagset;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MatchList {
    private PoliqarpConnection connection;
    private Match[] results;
    private int resultsCount;
    private static Map<PoliqarpConnection, MatchList> factoryData = new HashMap<PoliqarpConnection, MatchList>();
    private int cacheSize = 2000;
    private int cacheOffset = 0;
    private MatchCounter counter;
    private Query query;

    public static MatchList getMatchList(PoliqarpConnection poliqarpConnection, Query query) {
        MatchList matchList = factoryData.get(poliqarpConnection);
        if (matchList == null) {
            matchList = new MatchList(poliqarpConnection);
            factoryData.put(poliqarpConnection, matchList);
        } else {
            matchList.invalidate();
        }
        matchList.query = query;
        return matchList;
    }

    public static void unregisterConnection(PoliqarpConnection poliqarpConnection) {
        factoryData.remove(poliqarpConnection);
    }

    private Message queryBuffer() {
        try {
            this.connection.send("BUFFER-STATE");
            return this.connection.getMessage();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private int getBufferSize() {
        return this.queryBuffer().getOKIntInfo(0);
    }

    private int getBufferUsed() {
        return this.queryBuffer().getOKIntInfo(1);
    }

    MatchList(PoliqarpConnection poliqarpConnection) {
        this.connection = poliqarpConnection;
        this.results = new Match[this.cacheSize];
        this.counter = null;
    }

    public void createCounter(String string, Tagset tagset) throws StatQueryException {
        this.counter = string != null ? new MatchCounter(string, tagset) : null;
    }

    public void runCounter() {
        if (this.counter != null) {
            this.counter.count(this);
        }
    }

    public MatchCounter getCounter() {
        return this.counter;
    }

    void queryDone(int n) {
        this.resultsCount = n;
    }

    public void updateCount() {
        this.resultsCount = this.getBufferUsed();
    }

    private void ensureContaining(int n) {
        if (n >= this.cacheOffset && n < this.cacheOffset + this.cacheSize) {
            return;
        }
        int n2 = n - this.cacheSize / 2;
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 < this.cacheOffset) {
            int n3;
            for (n3 = this.cacheSize - 1; n3 >= this.cacheOffset - n2; --n3) {
                this.results[n3] = this.results[n3 - (this.cacheOffset - n2)];
            }
            while (n3 >= 0) {
                this.results[n3--] = null;
            }
        } else {
            int n4 = 0;
            for (int i = n2 - this.cacheOffset; i < this.cacheSize; ++i) {
                this.results[n4] = this.results[i];
                ++n4;
            }
            while (n4 < this.cacheSize) {
                this.results[n4++] = null;
            }
        }
        this.cacheOffset = n2;
    }

    public void prefetchMatches(int n, int n2) throws IllegalArgumentException {
        this.ensureContaining(n);
        while (n < n2) {
            int n3;
            while (n < n2 && this.results[n - this.cacheOffset] != null) {
                ++n;
            }
            for (n3 = n; n3 < n2 && this.results[n3 - this.cacheOffset] == null; ++n3) {
            }
            try {
                this.connection.send("GET-RESULTS " + n + " " + (n3 - 1));
                if (this.connection.getMessage().isOK()) {
                    for (int i = n; i < n3; ++i) {
                        this.results[i - this.cacheOffset] = new Match(this.query, this.connection);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new IllegalArgumentException();
            }
            n = n3;
        }
    }

    public Match getMatch(int n) throws IllegalArgumentException {
        if (n < 0 || n >= this.resultsCount) {
            throw new IllegalArgumentException();
        }
        this.ensureContaining(n);
        Match match = this.results[n - this.cacheOffset];
        if (match == null) {
            this.prefetchMatches(n, n + 1);
            match = this.results[n - this.cacheOffset];
        }
        return match;
    }

    public WideContext getWideContext(int n) throws IllegalArgumentException {
        WideContext wideContext = null;
        if (n < 0 || n >= this.resultsCount) {
            throw new IllegalArgumentException();
        }
        try {
            wideContext = new WideContext(this.connection, n);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException();
        }
        return wideContext;
    }

    public Iterator<Match> getIterator() {
        return this.counter == null ? new MatchIterator(this.connection, this.query, this.resultsCount) : new StatIterator(this.counter);
    }

    public MetaData getMetaData(int n) throws IllegalArgumentException {
        MetaData metaData = null;
        if (n < 0 || n >= this.resultsCount) {
            throw new IllegalArgumentException();
        }
        try {
            this.connection.send("METADATA " + n);
            Message message = this.connection.getMessage();
            if (message.isOK()) {
                metaData = new MetaData(this.connection, message.getOKIntInfo(0));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IllegalArgumentException();
        }
        return metaData;
    }

    public int count() {
        return this.resultsCount;
    }

    public void invalidate() {
        for (int i = 0; i < this.cacheSize; ++i) {
            this.results[i] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sortLetter(char c, Runnable runnable) {
        final Runnable runnable2 = runnable;
        AsyncHandler asyncHandler = new AsyncHandler(){

            public void handle(String string) {
                if (string.equals("SORTED")) {
                    MatchList.this.connection.setAsyncHandler(null);
                    SwingUtilities.invokeLater(runnable2);
                }
            }
        };
        this.connection.setAsyncHandler(asyncHandler);
        try {
            AsyncHandler asyncHandler2 = asyncHandler;
            synchronized (asyncHandler2) {
                this.connection.send("SORT " + c);
                Message message = this.connection.getMessage();
                if (!message.isOK()) {
                    return;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sort(int n, boolean bl, boolean bl2, Runnable runnable) {
        char c = (char)(65 + n + (bl ? 0 : 4));
        if (!bl2) {
            c = Character.toLowerCase(c);
        }
        this.sortLetter(c, runnable);
    }
}

