/*
 * Copyright (C) 2009 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 *
 * This file is part of WSDDE.
 *
 * WSDDE is free software: it may be distributed and/or modified under
 * the terms of the GNU General Public License version 3 as published
 * by the Free Software Foundation and appearing in the file doc/gpl.txt
 * included in the packaging of this file.
 *
 * A commercial license is available from IPI PAN (contact
 * Michal.Ciesiolka@ipipan.waw.pl or ipi@ipipan.waw.pl for more
 * information).  Licensees holding a valid commercial license from IPI
 * PAN may use this file in accordance with that license.
 *
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */

package wsdde;

import weka.classifiers.Classifier;
import weka.core.Utils;
import weka.filters.Filter;

/**
 * Loader for machine learning and selection algorithms from the WEKA package.
 * @author Project Manager
 *
 */
public class WEKALoader {

	//weka.filters.supervised.attribute.AttributeSelection -E "weka.attributeSelection.CfsSubsetEval " -S "weka.attributeSelection.BestFirst -D 1 -N 5"
	//weka.filters.MultiFilter -F "weka.filters.supervised.attribute.ClassOrder -R 1 -C 0" -F "weka.filters.supervised.attribute.AttributeSelection -E \"weka.attributeSelection.CfsSubsetEval \" -S \"weka.attributeSelection.BestFirst -D 1 -N 5\""
	
	
	/**
	 * Load a selection method based on constructionString (WEKA command line syntax).
	 * XML?
	 * 
	 */
	
	public static Filter filter(String constructionString) {
		Filter f = null;
		String[] optionsAll;
		String[] options;
		try {
			optionsAll = Utils.splitOptions(constructionString);
			options = new String[optionsAll.length-1];
			for (int i = 0; i < options.length; i++) {
				options[i]=optionsAll[i+1];
			}
			String filterName = optionsAll[0];//
			
		    f = (Filter)Utils.forName(Filter.class,
			                                          filterName,
			                                          options);
		
		
		} catch (Exception e) {
			e.printStackTrace();
		}
		return f;
	}
	
	/**
	 * 
	 * @param constructionString WEKA command which creates a classifier
	 * @return classifier built from the construction string
	 */
	public static Classifier classifier(String constructionString) {
		Classifier c = null;
		String[] optionsAll;
		String[] options;
		try {
			optionsAll = Utils.splitOptions(constructionString);
			options = new String[optionsAll.length-1];
			for (int i = 0; i < options.length; i++) {
				options[i]=optionsAll[i+1];
			}
			String classifierName = optionsAll[0];//
			
		    c = (Classifier)Utils.forName(Classifier.class,
			                                          classifierName,
			                                          options);
		
		
		} catch (Exception e) {
			e.printStackTrace();
		}
		return c;
	}
	
	public static void main(String [] args) {
		
	//	Classifier c = classifier("weka.classifiers.bayes.BayesNet -D -Q weka.classifiers.bayes.net.search.local.K2 -- -P 1 -S BAYES -E weka.classifiers.bayes.net.estimate.SimpleEstimator -- -A 0.5");
	//	c.getOptions();
	}
	
}
