/*
 * Copyright (C) 2009 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 *
 * This file is part of WSDDE.
 *
 * WSDDE is free software: it may be distributed and/or modified under
 * the terms of the GNU General Public License version 3 as published
 * by the Free Software Foundation and appearing in the file doc/gpl.txt
 * included in the packaging of this file.
 *
 * A commercial license is available from IPI PAN (contact
 * Michal.Ciesiolka@ipipan.waw.pl or ipi@ipipan.waw.pl for more
 * information).  Licensees holding a valid commercial license from IPI
 * PAN may use this file in accordance with that license.
 *
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */

package wsdde.corpus;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;



import wsdde.Counter;
import wsdde.general.Utils;


public class KWIC implements Serializable {

	public int kwicID; 

	private static final long serialVersionUID = -3365505737227452205L;

	public HashMap<String,Vector<ContextInfo>> infos;
	//plus another extra sources (e.g. shallow parsing, wordnet,...)

	int keywordIndex;
	
	public String sense;
	public String predictedSense;


	public Counter counter;

	
	
	public KWIC(int id) {
		infos = new HashMap<String,Vector<ContextInfo>>();
		infos.put("words",new Vector<ContextInfo>());
		infos.put("lemmas",new Vector<ContextInfo>());
		infos.put("posinfos",new Vector<ContextInfo>()); //TODO hardcoding...
		kwicID = id;
		counter = new Counter();
	}
	
	
	/**
	 * liczy sie kolejnosc wstawiania (isKeyword) - trzeba wstawiac po kolei (strumien tokenow)
	 * @param word
	 * @param lemma
	 * @param posinfo
	 * @param isKeyword - czy to jest kontekst czy keyword
	 */
	public void wstaw(Vector<String> typeOfInfo, Vector<ContextInfo> info, boolean isKeyword) {
		int i=0;
		for (String type : typeOfInfo) {
			Vector<ContextInfo> v = infos.get(type);
			v.add(info.get(i++));
		}
		if (isKeyword) {keywordIndex=infos.get("words").size()-1;}
	}
	
	
	//getters
	public ContextInfo getInfo(String info, int index) {//info = words, lemmas, etc. 0 = keyword, out of range = null) 
		index+=keywordIndex;
		if (index>-1 && index<infos.get(info).size()) {
			return infos.get(info).get(index);
		} else {
			return null;
		}
	}
	
	
	
	public String toString() {
		StringBuilder sb = new StringBuilder();
		StringBuilder temp;
		sb.append("CONTEXT ");
		sb.append(kwicID);
		sb.append("\n");
		sb.append("SENSE ");
		sb.append(sense);
		sb.append("\n");
		sb.append("PREDICTED_SENSE ");
		sb.append(predictedSense);
		sb.append("\n");
		
		/*sb.append(sense);
		sb.append("  zaklasyfikowany jako ");
		sb.append(predictedSense);
		if (!sense.equals(predictedSense)) {sb.append(" ERR!");}*/
		sb.append("\n");
		int indeks = 0;
		for (int i=0; i<infos.get("words").size(); i++) {
			indeks = i-keywordIndex;
			sb.append(Utils.fillWithZeros("TOK "+indeks+"",10));
			sb.append(Utils.fillWithZeros(infos.get("words").get(i).toString()+" ",20));
			sb.append(Utils.fillWithZeros(infos.get("lemmas").get(i).toString()+" ",20));
			sb.append(Utils.fillWithZeros(infos.get("posinfos").get(i).toString()+" ",10));
			//temp = new StringBuilder();
			/*Vector <String> s = getGramCatValue(indeks);
			for (String string : s) {
				temp.append(string);
				temp.append(" ");
			}*/
			//sb.append(temp);
			sb.append("\n");
		}
		//sb.append(fs);
		sb.append("\n");
		sb.append("END_OF_CONTEXT ");
		sb.append(kwicID);
		sb.append("\n");
		sb.append("\n");
		return sb.toString();
	}

	public String toHumanString() {
		int indeks = 0;
		StringBuffer sb = new StringBuffer();
		for (int i=keywordIndex-1; i<infos.get("words").size(); i++) {
			indeks = i-keywordIndex;
			if (indeks==0) {sb.append("****");}
			if (indeks==1) {sb.append("****");}
			sb.append(infos.get("words").get(i).toString());
			sb.append(' ');
			
		}
		return sb.toString();
	}
}