/*
 * Copyright (C) 2009 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 *
 * This file is part of WSDDE.
 *
 * WSDDE is free software: it may be distributed and/or modified under
 * the terms of the GNU General Public License version 3 as published
 * by the Free Software Foundation and appearing in the file doc/gpl.txt
 * included in the packaging of this file.
 *
 * A commercial license is available from IPI PAN (contact
 * Michal.Ciesiolka@ipipan.waw.pl or ipi@ipipan.waw.pl for more
 * information).  Licensees holding a valid commercial license from IPI
 * PAN may use this file in accordance with that license.
 *
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */
package wsdde.corpus;

import java.util.StringTokenizer;
import java.util.Vector;

public class POSInfo extends ContextInfo {
	
	String gram_class_string;
	Vector<String> gram_cat_strings;
	String pos_string;
	
	public POSInfo(String pos_string) {
		this.pos_string = pos_string;
		StringTokenizer st = new StringTokenizer(pos_string,":");
		gram_class_string = st.nextToken();
		gram_cat_strings = new Vector<String>();
		while (st.hasMoreTokens()) {
			gram_cat_strings.add(st.nextToken());
		}
	}

	public String getGramClassSimple() {//czyli tradycyjne czesci mowy jak np. czasownik)
		String verb = "pact|ppas|winien|praet|bedzie|fin|impt|aglt|ger|imps|inf|pant|pcon";
		String noun = "subst|depr|xxs|ger|ppron12|ppron3";
		if (verb.contains(gram_class_string)) return "verb";
		if (noun.contains(gram_class_string)) return "noun";
		return gram_class_string;
	}
	
	public String getGrammClass() {
		return gram_class_string;
	}
	
	public String gramCat(int i) {
		return gram_cat_strings.get(i);
	}
	
	public int gramCatNumber() {
		return gram_cat_strings.size();
	}
	
	public String toString() {
		return pos_string;
	}

}
