/*
 * Copyright (C) 2009 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 *
 * This file is part of WSDDE.
 *
 * WSDDE is free software: it may be distributed and/or modified under
 * the terms of the GNU General Public License version 3 as published
 * by the Free Software Foundation and appearing in the file doc/gpl.txt
 * included in the packaging of this file.
 *
 * A commercial license is available from IPI PAN (contact
 * Michal.Ciesiolka@ipipan.waw.pl or ipi@ipipan.waw.pl for more
 * information).  Licensees holding a valid commercial license from IPI
 * PAN may use this file in accordance with that license.
 *
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */

package wsdde.general;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;

public class Config extends Properties{
	
	
	
	public static enum Settings {
	//	TAKIPI_BIN("c:\\tmp\\takipi\\takipi.exe"),
		//TAKIPI_BIN("c:\\Documents and Settings\\Administrator\\My Documents\\PAN\\zasoby\\takipi\\takipi.exe"),
		TAKIPI_BIN("c:\\Documents and Settings\\Administrator\\My Documents\\PAN\\zasoby\\takipi\\takipi.exe"),
		
		POLIQARP_SERVER("localhost"),
		POLIQARP_PORT("4567"),
		POLIQARP_CORPUS("c:\\tmp\\2sampleKORPUS\\sample\\sample"),
	
		//DB_USED("mysql"),
		DB_USER("root"),
		DB_PASS("root"),
		DB_NAME("wsdde"),
		DB_SERVER("localhost"),
		DB_PORT("3306");
		
		
		
	
		private final String defaultValue; 
		
		Settings(String defaultValue) {
			this.defaultValue=defaultValue;
		}
		
		String defaultvalue() {return defaultValue;}	
		
		public String value() {
			return p.getProperty(this.toString());
		}
	}; 
	
	private static Config p;  
	
	static {
		//wczytaj z pliku
		p = new Config();
		p.defaults = new Properties();
		Reader rf;
		try {
			rf = new InputStreamReader(new FileInputStream("config.ini"), "UTF-8");
			//rf = new FileReader(new File("ustawienia.txt"));
			p.load(rf);
			
			
			//Writer wf = new FileWriter(new File("ustawienia.txt"));			
			//p.defaults.store(wf, "default values");
			
			//p.
		} catch (Exception e) {
			System.out.println("No config.ini; default values are used.");
		}
		for (Settings setting: Settings.values()){
			p.defaults.setProperty(setting.toString(), setting.defaultvalue());	
		}
		 
	}
	
	public Config() {
		super();
	}
	
	public static String property(Settings key) {
		return p.getProperty(key.toString());
	}
	/**
	 * 
	 */
	private static final long serialVersionUID = -7807775122612964598L;
	
	public static void main (String [] args) throws IOException {
		/*Wlasciwosci w = new Wlasciwosci();
		w.setProperty("TAKIPI_BIN", "trala");
	
		
		w.store(wf, "comment");*/
		//System.out.println(Settings.DB_USED.defaultvalue());
		System.out.println(Settings.TAKIPI_BIN.value());
		//System.out.println(Wlasciwosci.wlasciwosc(Settings.TAKIPI_BIN));
		
	}
	
	
}
