/*
 * Copyright (C) 2009 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 *
 * This file is part of WSDDE.
 *
 * WSDDE is free software: it may be distributed and/or modified under
 * the terms of the GNU General Public License version 3 as published
 * by the Free Software Foundation and appearing in the file doc/gpl.txt
 * included in the packaging of this file.
 *
 * A commercial license is available from IPI PAN (contact
 * Michal.Ciesiolka@ipipan.waw.pl or ipi@ipipan.waw.pl for more
 * information).  Licensees holding a valid commercial license from IPI
 * PAN may use this file in accordance with that license.
 *
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */
package wsdde.generator;

import java.util.HashMap;

import org.w3c.dom.Element;

import wsdde.corpus.ContextInfo;
import wsdde.corpus.KWIC;
import wsdde.corpus.POSInfo;
import wsdde.corpus.WSDCorpus;

/**
 * @author Rafał Młodzki
 *
 */
public class KFG extends FeatureGenerator  {

	public KFG(Element featureGeneratorElement) {
		super(featureGeneratorElement);
	}

	public KFG(HashMap<String, String> parameters) {
		super(parameters);
	}
	
	public KFG() {
		super();
	}


	public static String description() {
		return "KFG - about target keyword";
	}
	
	@Override
	public void generate(WSDCorpus contexts) {
		
		for (KWIC kwic : contexts) {			
			ContextInfo info;
			info = kwic.getInfo("words", 0);
			if (info!=null) {
				feature(contexts, kwic, info.toString());
			}
			POSInfo posinfo = (POSInfo)kwic.getInfo("posinfos", 0);
			if (posinfo!=null) {
				for (int i = 0; i < posinfo.gramCatNumber(); i++) {
					feature(contexts, kwic, posinfo.gramCat(i));	
				}
				feature(contexts, kwic, posinfo.getGrammClass());
			}
		}
		
	}

	
	public String id() {
		return "KFG";
	}



	@Override
	public HashMap<String, String> changeParam() {
		return parameters;
	}

	@Override
	public void prepareParams() {
	}

}
