/*
 * Copyright (C) 2009 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 *
 * This file is part of WSDDE.
 *
 * WSDDE is free software: it may be distributed and/or modified under
 * the terms of the GNU General Public License version 3 as published
 * by the Free Software Foundation and appearing in the file doc/gpl.txt
 * included in the packaging of this file.
 *
 * A commercial license is available from IPI PAN (contact
 * Michal.Ciesiolka@ipipan.waw.pl or ipi@ipipan.waw.pl for more
 * information).  Licensees holding a valid commercial license from IPI
 * PAN may use this file in accordance with that license.
 *
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */
package wsdde.generator;

import java.util.HashMap;
import java.util.Random;

import org.w3c.dom.Element;

import wsdde.corpus.KWIC;
import wsdde.corpus.POSInfo;
import wsdde.corpus.WSDCorpus;


/**
 * @author Rafał Młodzki
 *
 */
public class SFG2 extends FeatureGenerator {

	int windowSize; //= 3;
	int simple_gram_class; //= 1;*/
	int gram_cat_values;
	
	public SFG2(Element featureGeneratorElement) {
		super(featureGeneratorElement);
	}

	public SFG2(HashMap<String, String> parameters) {
		super(parameters);
	}
	
	public SFG2() {
		super();
	}
	
	@Override
	public void prepareParams() {
		windowSize =Integer.parseInt(getParam("window_size"));
		simple_gram_class =  Integer.parseInt(getParam("simple_gram_class"));
		gram_cat_values = Integer.parseInt(getParam("gram_cat_values"));
	}

	public static String description() {
		return "SFG2 based on POS";
	}
	
	
	@Override
	public void generate(WSDCorpus contexts) {
		
		for (KWIC kwic : contexts) {
			for (int i=-windowSize; i<=windowSize; i++) {
				if (i==0) {continue;}
				POSInfo posinfo = (POSInfo)kwic.getInfo("posinfos", i);
				if (posinfo!=null) {
					if (simple_gram_class==1) {
						feature(contexts, kwic, posinfo.getGramClassSimple()+(i<0?"":"+")+i);
					} else {
						feature(contexts, kwic, posinfo.getGrammClass()+(i<0?"":"+")+i);
					}
					if (gram_cat_values==1) {
						for (int j = 0; j < posinfo.gramCatNumber(); j++) {
							feature(contexts, kwic, posinfo.gramCat(j)+(i<0?"":"+")+i);	
						}
					}
				}
			}
			
		}
		
	}



	
	public String id() {
		return "SFG2";
	}

	
	@Override
	public HashMap<String, String> changeParam() {
		HashMap <String, String> hm = new HashMap<String, String>(parameters);
		if (Math.random()<0.3) {
			hm.put("simple_gram_class", (1-simple_gram_class)+"");
		} else {
			if (Math.random()<0.5) {
				Random r = new Random();
				hm.put("window_size", Math.abs(windowSize+r.nextInt(4)-2)+"");
			} else {
				hm.put("gram_cat_values", (1-gram_cat_values)+"");
			}
		}
		return hm;
	}

}
