/*
 * Copyright (C) 2009 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 *
 * This file is part of WSDDE.
 *
 * WSDDE is free software: it may be distributed and/or modified under
 * the terms of the GNU General Public License version 3 as published
 * by the Free Software Foundation and appearing in the file doc/gpl.txt
 * included in the packaging of this file.
 *
 * A commercial license is available from IPI PAN (contact
 * Michal.Ciesiolka@ipipan.waw.pl or ipi@ipipan.waw.pl for more
 * information).  Licensees holding a valid commercial license from IPI
 * PAN may use this file in accordance with that license.
 *
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */

package wsdde;

import java.util.Collections;
import java.util.Vector;

public class EvaluationResult {

	int correctCounter;
	int errorCounter;

	boolean interrupted;
	
	Vector<Integer> ids;
	Vector<String> kwics;
	Vector<String> predictions;
	Vector<String> senses;
	private long timeStarted;
	private long timeStopped;
	
	public EvaluationResult() {
		correctCounter = 0;
		errorCounter = 0;
		kwics = new Vector<String>();
		predictions = new Vector<String>();
		senses = new Vector<String>();
		ids = new Vector<Integer>();
	}

	
	
	public void add(int contextId, String contextRepresentation, String predictedSense, String sense) {		
		add(predictedSense.equalsIgnoreCase(sense));
		kwics.add(contextRepresentation);
		predictions.add(predictedSense);
		senses.add(sense);
		ids.add(contextId);
	}
	
	public void addCVFold() {
		kwics.add("CVFOLD");
		predictions.add("");
		senses.add("");
		ids.add(0);
	}
	
	public void add(boolean correct) {
		if (correct) {
			correctCounter++;
		} else {
			errorCounter++;
		}
	}
	
	public double getResult() {
		if (interrupted) {return 0;}
		return (1.0*correctCounter)/(correctCounter+errorCounter);
	} 
	
	public String detailedResults() {
		if (interrupted) {return "INTERRUPTED";}
		StringBuffer sb = new StringBuffer();
		sb.append(correctCounter);
		sb.append('/');
		sb.append(correctCounter+errorCounter);
		sb.append('(');
		sb.append((1.0*correctCounter)/(correctCounter+errorCounter));
		sb.append(')');
		sb.append("\nerrors: ");
		Vector<Integer> errors = new Vector<Integer>();
		for (int i = 0; i < kwics.size(); i++) {
			if (!predictions.get(i).equals(senses.get(i))) {
				errors.add(ids.get(i));
			}
		}
		Collections.sort(errors);
		for (Integer integer : errors) {
			sb.append(integer);
			sb.append(", ");
		}
		sb.append("\n*******************************\n");
		
//		for (int i = 0; i < kwics.size(); i++) {
//			sb.append(ids.get(i));
//			sb.append(' ');
//			sb.append(predictions.get(i));
//			sb.append(' ');
//			sb.append(senses.get(i));
//			sb.append(' ');
//			sb.append(kwics.get(i));
//			sb.append('\n');
//		}
		return sb.toString();
	}



	public void interrupted() {
		interrupted = true;
		
	}
	
	public boolean wasInterrupted() {
		return interrupted;
	}



	public void timeStart() {
		timeStarted = System.nanoTime();
	}



	public void timeStop() {
		timeStopped = System.nanoTime();
		
	}

	public long getElapssedTime() {
		return (int)((timeStopped-timeStarted)/1000000);
	}


	/**
	 * 
	 * @return error list (made by wsd method on the given corpus)
	 */

	public String getErrors() {
		StringBuffer sb = new StringBuffer();
		Vector<Integer> errors = new Vector<Integer>();
		for (int i = 0; i < kwics.size(); i++) {
			if (!predictions.get(i).equals(senses.get(i))) {
				errors.add(ids.get(i));
			}
		}
		Collections.sort(errors);
		for (Integer integer : errors) {
			sb.append(integer);
			sb.append(" ");
		}
		return sb.toString().trim();
	}
	
}
