/*
 * Copyright (C) 2009 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 *
 * This file is part of WSDDE.
 *
 * WSDDE is free software: it may be distributed and/or modified under
 * the terms of the GNU General Public License version 3 as published
 * by the Free Software Foundation and appearing in the file doc/gpl.txt
 * included in the packaging of this file.
 *
 * A commercial license is available from IPI PAN (contact
 * Michal.Ciesiolka@ipipan.waw.pl or ipi@ipipan.waw.pl for more
 * information).  Licensees holding a valid commercial license from IPI
 * PAN may use this file in accordance with that license.
 *
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */
package wsdde.corpus;



import ipipan.poliqarp.connection.PoliqarpConnection;

import ipipan.poliqarp.logic.QueryException;

import java.io.IOException;


public class PoliqarpContext {
	 
	 private String leftContext, leftMatch, rightMatch, rightContext;
	 private String pseudoMatch;
	 
	   /**
	    * Reads the description of this context from a connection.
	    */
	   PoliqarpContext(PoliqarpConnection connection, int index) 
	      throws IOException, QueryException
	   {
	      connection.send("GET-CONTEXT " + index);
	      if (!connection.getMessage().isOK())
	         throw new QueryException();
	      leftContext = connection.getMessage().toString();
	      leftMatch = connection.getMessage().toString();
	      rightMatch = connection.getMessage().toString();
	      rightContext = connection.getMessage().toString();
	   }

/*	public String toStringOrginally(){
	      return leftContext + leftMatch + rightMatch + rightContext;		
	}
*/	
	private String htmlize(String s) {
		return s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
	}
	
	public String toXML(){
		return "<context>"+ htmlize(leftContext) + 
				" <sense label=\""+ htmlize(leftMatch).trim() + htmlize(rightMatch).trim() + "\">" +htmlize(pseudoMatch)+"</sense>" + 
				htmlize(rightContext) + " </context>";
	}
	   
	public void setPseudoMatch(String pseudoMatch) {
		this.pseudoMatch = pseudoMatch;
	}

	public String getPseudoMatch() {
		return pseudoMatch;
	}
	   

}
