/*
 * Copyright (C) 2009 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 *
 * This file is part of WSDDE.
 *
 * WSDDE is free software: it may be distributed and/or modified under
 * the terms of the GNU General Public License version 3 as published
 * by the Free Software Foundation and appearing in the file doc/gpl.txt
 * included in the packaging of this file.
 *
 * A commercial license is available from IPI PAN (contact
 * Michal.Ciesiolka@ipipan.waw.pl or ipi@ipipan.waw.pl for more
 * information).  Licensees holding a valid commercial license from IPI
 * PAN may use this file in accordance with that license.
 *
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */

package wsdde.general;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import weka.core.FastVector;
import wsdde.corpus.KWIC;


public class Utils {
	
	public static void saveInFile(String what, String where) {
		try {
			File g = new File(where);
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(g),"UTF8"));
            out.write(what);
            out.close();

		} catch (Exception e) {
			e.printStackTrace();
		}
	}

       
	public static String fillWithZeros(String what, int zeros) {
		StringBuilder sb = new StringBuilder(what);
		int zerosNow = what.length();
		for (int i=0; i+zerosNow<zeros; i++) {
			sb.append(' ');
		}
		return sb.toString();
	}

	public static Document createDomDocument() {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            return doc;
        } catch (ParserConfigurationException e) {
        }
        return null;
    }
	
	public static String stringFromXML(Document doc){
		try{
			Transformer transformer = TransformerFactory.newInstance().newTransformer();
			transformer.setOutputProperty(OutputKeys.INDENT, "yes");			
			StreamResult result = new StreamResult(new StringWriter());
			DOMSource source = new DOMSource(doc);
			transformer.transform(source, result);	
			String xmlString = result.getWriter().toString();
			return xmlString;
		}
		catch (TransformerException e){
			return "";
		}
	}
	
	public static String readFromFile(String filename) {
		StringBuffer sb = new StringBuffer();
		try {
			BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(filename), "UTF-8"));
			String strLine;
		  	//Read File Line By Line
		    while ((strLine = br.readLine()) != null)   {
		    	sb.append(strLine);
		    }
		} catch (Exception e) {
			e.printStackTrace();
		}
		return sb.toString();
	}
	
	public static String convertStreamToString(InputStream is) {
        /*
         * To convert the InputStream to String we use the BufferedReader.readLine()
         * method. We iterate until the BufferedReader return null which means
         * there's no more data to read. Each line will appended to a StringBuilder
         * and returned as String.
         */
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();

        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                is.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        return sb.toString();
    }

	public static Document getXMLDocFromFile(String fileName) throws ParserConfigurationException, SAXException, IOException{
		DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
		DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
		Document doc;
		doc = docBuilder.parse(fileName);//.newDocument();
		return doc;
}

/**
 * 
 * @param element 
 * @return vector of child elements of 
 */
public static Vector<Element> getChildElementsVector(Element element){
	Vector<Element> ret = new Vector<Element>();		
	NodeList nl = element.getChildNodes();
	for(int i=0; i <nl.getLength(); i++){
		try{
			Element e = (Element)nl.item(i);
			ret.add(e);
		}catch(Exception e){
			;
		}
	}
	return ret;
	
}


	
}