/*
 * Copyright (C) 2009 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 *
 * This file is part of WSDDE.
 *
 * WSDDE is free software: it may be distributed and/or modified under
 * the terms of the GNU General Public License version 3 as published
 * by the Free Software Foundation and appearing in the file doc/gpl.txt
 * included in the packaging of this file.
 *
 * A commercial license is available from IPI PAN (contact
 * Michal.Ciesiolka@ipipan.waw.pl or ipi@ipipan.waw.pl for more
 * information).  Licensees holding a valid commercial license from IPI
 * PAN may use this file in accordance with that license.
 *
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */

package wsdde.general;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;

import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;

import org.xml.sax.SAXException;

import wsdde.generator.FeatureGenerator;

public class XML {


	
	
	public static String getMetaDescXSD() {
		
		StringBuffer sb= new StringBuffer();
		InputStream is = XML.class.getResourceAsStream("meta1.xsd");
		sb.append(Utils.convertStreamToString(is));
		sb.append(FeatureGenerator.getGeneratorsXSDs(true));
		is = XML.class.getResourceAsStream("meta2.xsd");
		sb.append(Utils.convertStreamToString(is));
		return sb.toString();
	}
	
	
	public static String getMetaDBDescXSD() {
		StringBuffer sb= new StringBuffer();
		InputStream is = XML.class.getResourceAsStream("metadb.xsd");
		sb.append(Utils.convertStreamToString(is));
		/*sb.append(FeatureGenerator.getGeneratorsXSDs());
		is = XML.class.getResourceAsStream("metadb2.xsd");
		sb.append(Utils.convertStreamToString(is));*/
		return sb.toString();
	}
	
	
	public static String getDescXSD() {
		//String FgXsd = 
		//return meta1+FgXsd+meta2;
		StringBuffer sb= new StringBuffer();
		InputStream is = XML.class.getResourceAsStream("desc1.xsd");
		sb.append(Utils.convertStreamToString(is));
		sb.append(FeatureGenerator.getGeneratorsXSDs(false));
		is = XML.class.getResourceAsStream("desc2.xsd");
		sb.append(Utils.convertStreamToString(is));
		return sb.toString();
	}
	
	
	
	public static boolean validateXSD(String xsd, String xmlFileName) throws Exception {
			//boolean ok = true;
		
		      // define the type of schema - we use W3C:
		      String schemaLang = "http://www.w3.org/2001/XMLSchema";

		      // get validation driver:
		      SchemaFactory factory = SchemaFactory.newInstance(schemaLang);
		      
		      // create schema by reading it from an XSD file:
		      InputStream is = new ByteArrayInputStream(xsd.getBytes("UTF-8"));
		      //Schema schema = factory.newSchema(new StreamSource("NewXMLSchema.xsd"));
		      Schema schema = factory.newSchema(new StreamSource(is));
		      
		      Validator validator = schema.newValidator();

		      // at last perform validation:
		      validator.validate(new StreamSource(xmlFileName));

		      
		      return true;
	}

	
	
}
