/*
 * Copyright (C) 2009 by Instytut Podstaw Informatyki Polskiej
 * Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 * Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 *
 * This file is part of WSDDE.
 *
 * WSDDE is free software: it may be distributed and/or modified under
 * the terms of the GNU General Public License version 3 as published
 * by the Free Software Foundation and appearing in the file doc/gpl.txt
 * included in the packaging of this file.
 *
 * A commercial license is available from IPI PAN (contact
 * Michal.Ciesiolka@ipipan.waw.pl or ipi@ipipan.waw.pl for more
 * information).  Licensees holding a valid commercial license from IPI
 * PAN may use this file in accordance with that license.
 *
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */
package wsdde.generator;

import java.util.HashMap;
import java.util.Random;

import org.w3c.dom.Element;

import wsdde.corpus.ContextInfo;
import wsdde.corpus.KWIC;
import wsdde.corpus.WSDCorpus;

/**
 * @author Rafał Młodzki
 *
 */
public class TFG extends FeatureGenerator  {

	int windowSize; //= 3;
	int lemmatisation; //= 1;*/

	
	public TFG(Element featureGeneratorElement) {
		super(featureGeneratorElement);
	}

	public TFG(HashMap<String, String> parameters) {
		super(parameters);
	}

	public TFG() {
		super();
	}

	
	@Override
	public void prepareParams() {
		windowSize =Integer.parseInt(getParam("window_size"));
		lemmatisation =  Integer.parseInt(getParam("lemmatisation"));
	}
	
	public static String description() {
		return "TFG = bag-of-words)";
	}
	

	@Override
	public void generate(WSDCorpus contexts) {
		
		for (KWIC kwic : contexts) {			
			ContextInfo info;
			for (int i=-windowSize; i<=windowSize; i++) {
				if (i==0) {continue;}
				if (lemmatisation>0){
					info = kwic.getInfo("lemmas", i);
					if (info!=null) {
						feature(contexts, kwic, info.toString());
					}
				} else {
					info = kwic.getInfo("words", i);
					if (info!=null) {
						feature(contexts, kwic, info.toString());
					}
				}
			}
			
		}
		
	}

	

	
	public String id() {
		return "TFG";
	}

		
	@Override
	public HashMap<String, String> changeParam() {
		HashMap <String, String> hm = new HashMap<String, String>(parameters);
		if (Math.random()<0.5) {
			hm.put("lemmatisation", (1-lemmatisation)+"");
		} else {
			Random r = new Random();
			hm.put("window_size", Math.abs(windowSize+r.nextInt(10)-2)+"");
		}
		return hm;
	}
}
