/*
 * @(#)CodegenOutputCodec.java created 20.06.2006
 * 
 * Copyright (c) 2006 Alexander Koller
 *  
 */

package de.saar.chorus.domgraph.codec.codegen;

import java.io.IOException;
import java.io.Writer;

import org._3pq.jgrapht.Edge;

import de.saar.chorus.domgraph.GlobalDomgraphProperties;
import de.saar.chorus.domgraph.codec.CodecMetadata;
import de.saar.chorus.domgraph.codec.MalformedDomgraphException;
import de.saar.chorus.domgraph.codec.MultiOutputCodec;
import de.saar.chorus.domgraph.graph.DomGraph;
import de.saar.chorus.domgraph.graph.NodeLabels;
import de.saar.chorus.domgraph.graph.NodeType;

@CodecMetadata(name="domgraph-codegen", extension=".java")
public class CodegenOutputCodec extends MultiOutputCodec {
    private int methIdx = 1;
    
    private String getNodeData(DomGraph graph, String node) {
        return "new NodeData(NodeType." + graph.getData(node).getType() + ")";
    }
    
    private String getEdgeData(DomGraph graph, Edge edge) {
        return "new EdgeData(EdgeType." + graph.getData(edge).getType() + ")";
    }

    @Override
    public void encode(DomGraph graph, NodeLabels labels, Writer writer) throws IOException, MalformedDomgraphException {
        writer.write("\n    public void makeGraph" + (methIdx++) + "(DomGraph graph, NodeLabels labels) {\n");
        writer.write("        graph.clear();\n");
        writer.write("        labels.clear();\n\n");

        for( String node : graph.getAllNodes() ) {
            writer.write("        graph.addNode(\"" + node + "\", " + getNodeData(graph, node) + ");\n");
            
            if( graph.getData(node).getType() == NodeType.LABELLED ) {
                writer.write("        labels.addLabel(\"" + node + "\", \"" + labels.getLabel(node) + "\");\n");
            }
        }
        
        writer.write("\n");
        for( Edge edge : graph.getAllEdges() ) {
            String src = (String) edge.getSource();
            String tgt = (String) edge.getTarget();
            
            writer.write("        graph.addEdge(\"" + src + "\", \"" + tgt + "\", " +
                    getEdgeData(graph,edge) + ");\n");
        }

        writer.write("    }\n");
        writer.flush();
    }

    @Override
    public void print_header(Writer writer) throws IOException {
        writer.write("/*\n" +
                " * autogenerated by " + GlobalDomgraphProperties.getSystemName() + "\n" +
                " * (see " + GlobalDomgraphProperties.getHomepage() + " for details)\n" +
                " */\n\n");
        
        writer.write("class DomgraphGenerator {\n\n");
    }

    @Override
    public void print_footer(Writer writer) throws IOException {
        writer.write("\n}\n");
        writer.flush();
    }

    @Override
    public void print_start_list(Writer writer) throws IOException {
        // TODO Auto-generated method stub
        
    }

    @Override
    public void print_end_list(Writer writer) throws IOException {
        // TODO Auto-generated method stub
        
    }

    @Override
    public void print_list_separator(Writer writer) throws IOException {
        // TODO Auto-generated method stub
        
    }

}
