/* Generated By:JavaCC: Do not edit this line. DomconOzInputCodec.java */
package de.saar.chorus.domgraph.codec.domcon;

import java.io.*;
import java.util.*;

import de.saar.chorus.domgraph.graph.*;
import de.saar.chorus.domgraph.codec.*;

import org.testng.annotations.ExpectedExceptions;
import org.testng.annotations.Test;


/**
 * An input codec for weakly normal dominance constraints in Oz syntax. The
 * inputs that this codec accepts are lists of Oz terms; these terms
 * represent dominance and labelling atoms.<p>
 *
 * An example input looks as follows:<p>
 * <code>[label(x f(y)) dom(y z) label(z a)]</code><p>
 *
 * The dominance constraint represented by the Oz term is read as a
 * weakly normal dominance constraint, i.e. we require that the
 * right-hand sides of dominance atoms are roots, and we assume that
 * there is an implicit inequality atom for each pair of labelled
 * variables.<p>
 *
 * The constraints accepted by this codec are compatible with the
 * old CHORUS demo. A line that starts with a percent sign is
 * interpreted as a comment.
 * 
 * @author Alexander Koller
 *
 */
@CodecMetadata(name="domcon-oz", extension=".clls")
public class DomconOzInputCodec extends InputCodec implements DomconOzInputCodecConstants {
    private DomGraph graph;
    private NodeLabels labels;
  private List<String> varlist;

    @CodecConstructor
    public DomconOzInputCodec() {
        this((Reader) null);
        varlist = new ArrayList<String>();
    }

    public void decode(Reader inputStream, DomGraph graph, NodeLabels labels)
        throws IOException, ParserException, MalformedDomgraphException {

        this.graph = graph;
        this.labels = labels;

        graph.clear();
        labels.clear();
        varlist.clear();

        try {
            ReInit(inputStream);
            Input();
        } catch(Throwable e) {
//	    e.printStackTrace(System.err);
            throw new ParserException(e);
        }
    }


    private String stripquotes(String label) {
        if( label.startsWith("\'") ) {
            // strip off first and last character
            return label.substring(1, label.length()-1);
        } else {
            return label;
        }
    }

/*
 * grammar
 */

// start symbol: Input
  final public void Input() throws ParseException {
    jj_consume_token(9);
    label_1:
    while (true) {
      Atom();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LABEL:
      case DOM:
        ;
        break;
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
    }
    jj_consume_token(10);
  }

  final public void Atom() throws ParseException {
  String x,y;
  Token f;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DOM:
      jj_consume_token(DOM);
      jj_consume_token(11);
      x = Variable();
      y = Variable();
      jj_consume_token(12);
         graph.addEdge(x, y,
                       new EdgeData(EdgeType.DOMINANCE));
      break;
    case LABEL:
      jj_consume_token(LABEL);
      jj_consume_token(11);
      x = Variable();
      f = jj_consume_token(OZATOM);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 11:
        jj_consume_token(11);
        Varlist();
        jj_consume_token(12);
        break;
      default:
        jj_la1[1] = jj_gen;
        ;
      }
      jj_consume_token(12);
      // INVARIANT: varlist is empty each time we start recognising
      // a labelling atom. It is filled while parsing the Varlist.

        graph.getData(x).setType(NodeType.LABELLED);
        labels.addLabel(x, stripquotes(f.image));

        for( String child : varlist ) {
            graph.addEdge(x, child,
                          new EdgeData(EdgeType.TREE));
        }

        varlist.clear();
      break;
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void Varlist() throws ParseException {
  String t;
    label_2:
    while (true) {
      t = Variable();
                   varlist.add(t);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OZATOM:
        ;
        break;
      default:
        jj_la1[3] = jj_gen;
        break label_2;
      }
    }
  }

  final public String Variable() throws ParseException {
  Token t;
    // Variable -> OZATOM
      t = jj_consume_token(OZATOM);
    String nodename = stripquotes(t.image);

    if( !graph.hasNode(nodename) ) {
      graph.addNode(nodename, new NodeData(NodeType.UNLABELLED));
    }

    {if (true) return nodename;}
    throw new Error("Missing return statement in function");
  }

  public DomconOzInputCodecTokenManager token_source;
  SimpleCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[4];
  static private int[] jj_la1_0;
  static {
      jj_la1_0();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {0xc0,0x800,0xc0,0x100,};
   }

  public DomconOzInputCodec(java.io.InputStream stream) {
     this(stream, null);
  }
  public DomconOzInputCodec(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new DomconOzInputCodecTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 4; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 4; i++) jj_la1[i] = -1;
  }

  public DomconOzInputCodec(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new DomconOzInputCodecTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 4; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 4; i++) jj_la1[i] = -1;
  }

  public DomconOzInputCodec(DomconOzInputCodecTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 4; i++) jj_la1[i] = -1;
  }

  public void ReInit(DomconOzInputCodecTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 4; i++) jj_la1[i] = -1;
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[13];
    for (int i = 0; i < 13; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 4; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 13; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

}
