/* Generated By:JavaCC: Do not edit this line. GlueInputCodec.java */
package de.saar.chorus.domgraph.codec.glue;

import java.io.*;
import java.util.*;

import de.saar.chorus.domgraph.codec.*;
import de.saar.chorus.domgraph.graph.*;

import java.util.HashMap;
import java.util.Map;


/**
 * An experimental input codec for LFG-style Glue Semantics 
 * axiom sets. The purpose of this codec is for experimenting
 * with different translations of Glue to dominance graphs in
 * the context of Etienne's MSc thesis.<p>
 *
 * The concrete syntax of the input is ad-hoc and doesn't reflect
 * the format of the formulas computed by the XLE. Glue formulas
 * can be built up from variables (starting with uppercase letters),
 * atoms (starting with lowercase letters), and the implication
 * symbol <code>-o</code>. If the antecedent of an implication is not atomic
 * (i.e. not an atom or a variable), then it must be surrounded by
 * brackets. The consequent of an implication may <i>never</i> be
 * in brackets. We will presumably switch to a different concrete
 * syntax at some point, so there's no point in making the parser
 * perfect right now.<p>
 *
 * An example input looks as follows:<p>
 * <code>[(((X -o z) -o w) -o a) -o Y, (X -o a) -o b -o c, Y]</code><p>
 *
 * @author Etienne Ailloud
 * @author Alexander Koller
 *
 */

@CodecMetadata(name="glue", extension=".glue", experimental=true)
public class GlueInputCodec extends InputCodec implements GlueInputCodecConstants {
        private DomGraph graph;
    private NodeLabels labels;

        private List<Formula> formulas;
        // Variable-to-formula mapping - meant to emulate the "type inference"
        private Map<String,Formula> varToFormula;

        @CodecConstructor
        public GlueInputCodec() {
          this((Reader) null);
          varToFormula = new HashMap<String,Formula>();
//	  behavior = new HashMap[];
          formulas = new ArrayList<Formula>();
    }

/*	Subroutine z corresponds to the auxiliary mapping of formulas z in the paper;
	it modifies the graph g and labels l passed in parameter
*/

        private void z(int j, Formula phi, String address, DomGraph g, NodeLabels l, List<Formula> axioms) {
        switch ( phi.getType() ) {
        case IMPLICATION:
                        Formula psi = phi.getSubformulas().get(0);
                        Formula chi = phi.getSubformulas().get(1);
                        NodeData conclusion = new NodeData(NodeType.LABELLED);
                        NodeData premiss = new NodeData(NodeType.LABELLED);
                        // Address may not be at this point the empty word
                        String addr_cc = address.substring(0, address.length()-1);
                        String addr_pr = addr_cc + "2";
                        String name_cc = "X" + String.valueOf(j+1) + addr_cc;
                        String name_pr = "X" + String.valueOf(j+1) + addr_pr;
                        String name_impl = "X" + String.valueOf(j+1) + address;
                        g.addNode(name_cc, conclusion);
                //l.addLabel(name_cc, "-o E");
                l.addLabel(name_cc, chi.toString());
                        g.addNode(name_pr, premiss);
                        // Updates the Variable-to-formula map
                        varToFormula.put(name_pr, psi);
                        varToFormula.put(name_cc, chi);
                        // Creates the labelling edges
                        EdgeData left = new EdgeData(EdgeType.TREE);
                        EdgeData right = new EdgeData(EdgeType.TREE);
                        g.addEdge(name_cc, name_impl, left);
                        g.addEdge(name_cc, name_pr, right);
                        List<Formula> other_axioms = new ArrayList<Formula>(axioms);
                        other_axioms.remove(axioms.get(j));
                if ( !psi.isSuffixModuloUnif(other_axioms) ) {
                                l.addLabel(name_pr, "[" + psi.toString() + "]");
                        z(j, chi, addr_cc, g, l, formulas);
                } else {
                        z(j, chi, addr_cc, g, l, formulas);
                /* 	if psi is not a suffix, branching downward does not necessarily
			yield a label for the right-bottom node (corresp. to "premiss")
			(only if the downward recursion (subroutine w) is not trivial):
		*/
                        premiss.setType(NodeType.UNLABELLED);
                        w(j, psi, addr_pr, g, l);
                }
        case ATOM:
        case VARIABLE:
        //	should always match the following test - provided depth is computed accurately
            if ( address == "" ) break;
        }
        }

        private void w(int j, Formula phi, String address, DomGraph g, NodeLabels l) {
                switch ( phi.getType() ) {
                case IMPLICATION:
                        Formula psi = phi.getSubformulas().get(0);
                Formula chi = phi.getSubformulas().get(1);
                        // same remark as above: a priori, the new node downward needs not be labelled
                        NodeData conclusion = new NodeData(NodeType.UNLABELLED);
                        String addr_cc = address + "1";
                        String name_cc = "X" + String.valueOf(j+1) + addr_cc;
                        g.addNode(name_cc, conclusion);
                        // sets label for the implication-introduction node, previously defined
                        String name_impl = "X" + String.valueOf(j+1) + address;
                        NodeData implication = g.getData(name_impl);
                        implication.setType(NodeType.LABELLED);
                        l.addLabel(name_impl, "-o I, " + psi.toString());
                        // updates the variable-to-formula map
                        varToFormula.put(name_cc, chi);
                        // creates the labelling edge
                        EdgeData edge = new EdgeData(EdgeType.TREE);
                        g.addEdge(name_impl, name_cc, edge);
                        w(j, chi, addr_cc, g, l);
                case ATOM:
                case VARIABLE:
                }
        }


        private void updateBehavior(int j, HashMap[] behavior) {
                HashMap<Formula, Integer> res = new HashMap();
                Set<String> fragment = graph.getFragment("X" + String.valueOf(j+1));
                for( String node_name : fragment ) {
                        NodeData nd = graph.getData(node_name);
                        if( nd.getType() == NodeType.LABELLED ) {
                                Formula F = (Formula) varToFormula.get(node_name);
                                String label = labels.getLabel(node_name);
                                if( label.contains("-o I") ) {
                                        // the node has value "phi -o psi"
                                        // (if it wasn't an implication there shouldn't be a label "ii"),
                                        // but the label is "ii_<phi>"
                                        F = F.getSubformulas().get(0);
                                        if( res.containsKey(F) ) {
                                                Integer aux = res.get(F);
                                                res.remove(F);
                                                res.put(F, new Integer(aux.intValue() - 1));
                                        } else
                                                res.put(F, new Integer(-1));
                                } else if( label.contains("[") ) {
                                        if( res.containsKey(F) )
                                                res.put(F, new Integer(res.get(F).intValue() + 1));
                                        else
                                                res.put(F, new Integer(1));
                                }
                        }
                }
                behavior[j] = res;
        }

    public void decode(Reader inputStream, DomGraph graph, NodeLabels labels)
        throws IOException, ParserException, MalformedDomgraphException {
                this.graph = graph;
                this.labels = labels;

                graph.clear();
                labels.clear();
                formulas.clear();

                try {
                ReInit(inputStream);
                    list();


                    /*
		     * At this point, we have the LL formulas as members
		     * of the "formulas" field. This is where they would now
		     * have to be translated into the "graph" and "labels"
		     * objects. 
		     *
		     * Etienne, feel free to implement any methods you want
		     * in this class or to put them into new classes in this
		     * package. Just be sure to not make them public.
		     */

                    System.out.println(formulas);
                } catch(Throwable e) {
                    throw new ParserException(e);
                }

                for ( int i = 0; i < formulas.size(); i++ ) {
                        // Compute the fragment related to each axiom
                        Formula axiom = formulas.get(i);
//            System.out.println(axiom.getSuffixes());            
             /* Add first node, labelled with axiom and index; the name is also indexed by
			  * the formula's address (as many 1s as the implicative depth)
			  */
                        NodeData axNode = new NodeData(NodeType.LABELLED);
                        String axAddress;
                                                StringBuffer sb = new StringBuffer();
                                                for (int d = 0; d < axiom.depth(); ++d) {
                                                        sb.append("1");
                                                }
                                                axAddress = sb.toString();
                        String name = "X" + String.valueOf(i+1) + axAddress;
                        graph.addNode(name, axNode);
                        //labels.addLabel(name, "ax"+String.valueOf(i+1));
                        labels.addLabel(name, axiom.toString());
                        varToFormula.put(name, axiom);

              /* Recursive call on the axiom formula
			   * (to simulate the auxiliary function z);
			   * expands the constraint ("graph" and "labels") obtained so far
			   */
                        z(i, axiom, axAddress, graph, labels, formulas);
                }

                // Proper dominance atoms

                // For every fragment, a map that describes its behavior w.r.t. resources:
                // g=1  -> produces a g via [g]
                // g=-1 -> consumes a g via ii_<g>
                HashMap[] hypBehavior = new HashMap[formulas.size()];
                for( int i = 0; i < formulas.size(); i++)
                        hypBehavior[i] = new HashMap<Formula,Integer>();
                // Collect fragment from each axiom
                System.out.println(varToFormula);
                List<Set<String>> fragments = new ArrayList<Set<String>>(formulas.size());
                for ( int i = 0; i < formulas.size(); i++ ) {
                        String rooti = "X" + String.valueOf(i+1);
                        updateBehavior(i, hypBehavior);
                        fragments.add(i, graph.getFragment(rooti));
                        Set<String> Fi = fragments.get(i);
                        Map<Formula,Integer> m = (Map<Formula,Integer>)hypBehavior[i];
                        System.out.println(m);
                        for( int j = 0; j < i; j++ ) {
                                String rootj = "X" + String.valueOf(j+1);
                                Set<String> Fj = fragments.get(j);
                                Map<Formula,Integer> n = hypBehavior[j];
                                System.out.println("\t" + n.toString());
                                for( Formula i_res : m.keySet() )
                                        // if it contains a key, then there can be only one entry:
                                        // at most one behavior (-1, 0, +1; or none) for each resource in each fragment
                                        for( Formula j_res : n.keySet() )
                                                if( i_res.equals(j_res) ) {
                                                        if ( m.get(i_res).intValue() < n.get(j_res).intValue() ) {
                                                                // if behaviors may plug in each other,
                                                                // 1. check type of root and hole
                                                                // 2. add dominance edge
                                                                String root = graph.getRoot(rootj);// extracts the root of Fj from the root of Fj...
                                                                for( String hole : graph.getHoles(Fi) ) {
                                                                        String holeParent = hole.substring(0, hole.length()-1);
                                                                        if( varToFormula.get(hole).subsumes(varToFormula.get(root)) &&
                                                                                i_res.equals(varToFormula.get(holeParent).getSubformulas().get(0))) {
                                                                                EdgeData edge = new EdgeData(EdgeType.DOMINANCE);
                                                                                graph.addEdge(hole, root, edge);
                                                                                break;
                                                                        }
                                                                }
                                                        } else if (m.get(i_res).intValue() > n.get(j_res).intValue()) {
                                                                // idem...
                                                                String root = graph.getRoot(rooti);
                                                                for( String hole : graph.getHoles(Fj) ) {
                                                                        String holeParent = hole.substring(0, hole.length()-1);
                                                                        if( varToFormula.get(hole).subsumes(varToFormula.get(root)) &&
                                                                                j_res.equals(varToFormula.get(holeParent).getSubformulas().get(0))) {
                                                                                EdgeData edge = new EdgeData(EdgeType.DOMINANCE);
                                                                                graph.addEdge(hole, root, edge);
                                                                                break;
                                                                        }
                                                                }
                                                        }
                                                // no else: nothing happens if two fragments exhibit the same behavior w.r.t. the same resource
                                                }
                        }
                }
                // all dominance edges based on hypotheses have been attributed;
                // now the rest must match holes not yet attributed to roots.
                for ( int i = 0; i < fragments.size(); i++ ) {
                        String rooti = "X" + String.valueOf(i+1);
                        List<String> oh = graph.getOpenHoles(rooti);
                        if(!oh.isEmpty())
                                for( int j = 0; j < fragments.size() - 1; j++ ) {
                                        String rootj = "X" + String.valueOf(j+1);
                                        for( String hole : oh )
                                                // the test is here EQUALITY, and not SUBSUMPTION!!!
                                                // --> assumption to be checked!
                                                if( varToFormula.get(hole).equals(varToFormula.get(rootj)) ) {
                                                        EdgeData edge = new EdgeData(EdgeType.DOMINANCE);
                                                        graph.addEdge(hole, rootj, edge);
                                                        break;
                                                }
                                }
                }
        }

  final public void list() throws ParseException {
        Formula f;
    jj_consume_token(9);
    f = formula();
                           formulas.add(f);
    label_1:
    while (true) {
      if (jj_2_1(2)) {
        ;
      } else {
        break label_1;
      }
      jj_consume_token(10);
      f = formula();
                                   formulas.add(f);
    }
    jj_consume_token(11);
  }

  final public Formula formula() throws ParseException {
        Formula sub1, sub2;
    if (jj_2_2(2)) {
      jj_consume_token(12);
      sub1 = formula();
      jj_consume_token(13);
      jj_consume_token(IMP);
      sub2 = formula();
                {if (true) return new Formula(Formula.Type.IMPLICATION, sub1, sub2);}
    } else if (jj_2_3(2)) {
      sub1 = VarOrAtom();
      jj_consume_token(IMP);
      sub2 = formula();
                {if (true) return new Formula(Formula.Type.IMPLICATION, sub1, sub2);}
    } else if (jj_2_4(2)) {
      sub1 = VarOrAtom();
                {if (true) return sub1;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Formula VarOrAtom() throws ParseException {
        Token t;
    if (jj_2_5(2)) {
      t = jj_consume_token(VAR);
                {if (true) return new Formula(Formula.Type.VARIABLE, t.image);}
    } else if (jj_2_6(2)) {
      t = jj_consume_token(ATOM);
                {if (true) return new Formula(Formula.Type.ATOM, t.image);}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  final private boolean jj_3_1() {
    if (jj_scan_token(10)) return true;
    if (jj_3R_2()) return true;
    return false;
  }

  final private boolean jj_3R_2() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_2()) {
    jj_scanpos = xsp;
    if (jj_3_3()) {
    jj_scanpos = xsp;
    if (jj_3_4()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_scan_token(12)) return true;
    if (jj_3R_2()) return true;
    return false;
  }

  final private boolean jj_3_4() {
    if (jj_3R_3()) return true;
    return false;
  }

  final private boolean jj_3R_3() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_5()) {
    jj_scanpos = xsp;
    if (jj_3_6()) return true;
    }
    return false;
  }

  final private boolean jj_3_6() {
    if (jj_scan_token(ATOM)) return true;
    return false;
  }

  final private boolean jj_3_5() {
    if (jj_scan_token(VAR)) return true;
    return false;
  }

  final private boolean jj_3_3() {
    if (jj_3R_3()) return true;
    if (jj_scan_token(IMP)) return true;
    return false;
  }

  public GlueInputCodecTokenManager token_source;
  SimpleCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[0];
  static private int[] jj_la1_0;
  static {
      jj_la1_0();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[6];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public GlueInputCodec(java.io.InputStream stream) {
     this(stream, null);
  }
  public GlueInputCodec(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new GlueInputCodecTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public GlueInputCodec(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new GlueInputCodecTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public GlueInputCodec(GlueInputCodecTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(GlueInputCodecTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector<int[]> jj_expentries = new java.util.Vector<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration e = jj_expentries.elements(); e.hasMoreElements();) {
        int[] oldentry = (int[])(e.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[14];
    for (int i = 0; i < 14; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 0; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 14; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 6; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
