/*
 *  File ParseTreeCollection.java
 *
 *  Authors:
 *     Johannes Dellert  <johannes.dellert@sfs.uni-tuebingen.de>
 *     
 *  Copyright:
 *     Johannes Dellert, 2007
 *
 *  Last modified:
 *     Di 16. Okt 20:05:21 CEST 2007
 *
 *  This file is part of the TuLiPA system
 *     http://www.sfb441.uni-tuebingen.de/emmy-noether-kallmeyer/tulipa
 *
 *  TuLiPA is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TuLiPA is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package de.tuebingen.gui;

import java.util.*;

import de.tuebingen.expander.DOMWriter;
import de.tuebingen.semantics.UToolRunner;
import de.tuebingen.tag.SemLit;

public class ParseTreeCollection
{
    XMLViewTree derivationTree;
    XMLViewTree derivedTree;
    
    ArrayList<XMLViewTree> elementaryTrees;
    ArrayList<XMLViewTree> derivationSteps;
    
    String semantics;
    List<SemLit> realSemantics;
    String[] specifiedSemantics;
    
    public ParseTreeCollection(XMLViewTree derivationTree, XMLViewTree derivedTree, String semantics, List<SemLit> lsl, boolean noUtool)
    {
        this.derivationTree = derivationTree;
        this.derivedTree = derivedTree;
        elementaryTrees = null;
        derivationSteps = null;
        this.semantics = semantics;
        if (!noUtool) {
	        this.specifiedSemantics = UToolRunner.process(lsl);
	        this.semantics += "<br>Reading(s):<br>";
	        if (specifiedSemantics != null) {
		        for(String s : specifiedSemantics) {
		        	this.semantics += s + "<br>";
		        }
	        }
        }
        this.realSemantics = lsl;
    }
    
    public String toString()
    {
        return derivationTree.description;
    }
    
    public String toXML()
    {
        String out = "";
        out += "  <parse>\n    <derivation>\n";
        out += DOMWriter.elementToString(derivationTree.domNodes.get(0), 3);
        out += "    </derivation>\n    <derived>\n";
        out += DOMWriter.elementToString(derivedTree.domNodes.get(0), 3);
        out += "    </derived>\n  </parse>\n";
        return out;
    }
    
    public XMLViewTree getDerivationTree(){
    	return derivationTree;
    }
    
    public XMLViewTree getDerivedTree(){
    	return derivedTree;
    }
    
    public List<SemLit> getSemantics() {
    	return realSemantics;
    }
    
    public String[] getSpecifiedSemantics() {
    	return specifiedSemantics;
    }
}
