/*
 *  File Vertex.java
 *
 *  Authors:
 *     Johannes Dellert
 *     
 *  Copyright:
 *     Johannes Dellert, 2009
 *
 *  Last modified:
 *     Do 16. Apr 09:55:36 CEST 2009
 *
 *  This file is part of the TuLiPA system
 *     http://www.sfb441.uni-tuebingen.de/emmy-noether-kallmeyer/tulipa
 *
 *  TuLiPA is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TuLiPA is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package de.tuebingen.gui.graph;

import java.util.*;

public class Vertex
{
    public ArrayList<Edge> edges;
    
    private String caption;
    
    public Vertex(String caption)
    {
        this.caption = caption;
        this.edges = new ArrayList<Edge>();
    }
    
    public static Vertex createDummyVertex()
    {
        Vertex v = new Vertex("?");
        return v;
    }
    
    public void addEdge(Edge edge)
    {
        edges.add(edge);
    }

    public void setCaption(String caption)
    {
        this.caption = caption;
    }

    public String getCaption()
    {
        return caption;
    }
    
    public boolean equals (Object o)
    {
        if (o.getClass() != this.getClass())
        {
            return false;
        }
        else
        {
            return false;
        }
    }
}
