package parser;

import java.util.LinkedList;
import java.util.List;

public enum Feature {
	
	//treebankowe
	AGLUTYN("aglutyn", false, true),
	AKCENT("akcent", false, true),
	AKOM("akom", true, true),
	ASPEKT("aspekt", true, true),
	CZAS("czas", true, false),
	DEST("dest", true, false),
	INK("ink", true, false),
	KOR("kor", true, false),
	KLASA("klasa", true, false),
	KROPK("kropk", false, true),
	KSZT("kszt", true, false),
	LICZBA("liczba", true, true),
	NEG("neg", true, true),
	OSOBA("osoba", true, true),
	OZN("ozn", true, false),
	POPRZYIMK("poprzyimk", false, true),
	POZ("poz", true, false),
	PRZYPADEK("przypadek", true, true),
	PRZYIMEK("przyim", true, false),
	REKCJA("rekcja", true, false),
	RODZAJ("rodzaj", true, true),
	STOPIEN("stopień", true, true),
	//ZMIENIONE 30.04
	TAG("tag", false, false),
	TRYB("tryb", true, false),
	TFW("tfw", true, false),
	TFZ("tfz", true, false),
	TYP("typ", true, false),
	TYP_C("typc", true, false),
	TYP_N("typn", true, false),
	WOKAL("wokal", false, true),
	WYROZNIK("wyróżnik", true, false),
	ZAP("zap", true, false),
	//wlasne
	POS("pos", false, false),
	JAKO_FL("jakofl", false, false),
	NIL("nil", false, false);
	
	//public static Feature[] terminalFeatures = { Feature.LICZBA, Feature.PRZYPADEK, Feature.RODZAJ, Feature.OSOBA };
	
	private static List<Feature> nonterminalFeatures = null;
	private static List<Feature> terminalFeatures = null;
	
	private String fname;
	private boolean nonterminal;
	private boolean terminal;
	
	private Feature(String fname, boolean nonterminal, boolean terminal) {
		this.fname = fname;
		this.nonterminal = nonterminal;
		this.terminal = terminal;
	}
	
	public static Feature makeFeature(String fname) {
		for (Feature f : Feature.values()) {
			if (f.fname.contentEquals(fname)) {
				return f;
			}
		}
		System.out.println("unknown feature: " + fname);
		return Feature.NIL;
		//throw new NullPointerException();
	}
	
	public String getFname() {
		return this.fname;
	}
	
	public static List<Feature> nonterminalFeatures() {
		if (Feature.nonterminalFeatures == null) {
			Feature.nonterminalFeatures = new LinkedList<Feature>();
			for (Feature f : Feature.values()) {
				if (f.nonterminal) {
					Feature.nonterminalFeatures.add(f);
				}
			}
		}
		return Feature.nonterminalFeatures;
	}
	
	public static List<Feature> terminalFeatures() {
		if (Feature.terminalFeatures == null) {
			Feature.terminalFeatures = new LinkedList<Feature>();
			for (Feature f : Feature.values()) {
				if (f.terminal) {
					Feature.terminalFeatures.add(f);
				}
			}
		}
		return Feature.terminalFeatures;
	}

}
