package parser;

public enum POS {
	
	ADJ("adj"),
	ADJA("adja"),
	ADJC("adjc"),
	ADJP("adjp"),
	ADV("adv"),
	AGLT("aglt"),
	BEDZIE("bedzie"),
	BREV("brev"),
	COMP("comp"),
	CONJ("conj"),
	DEPR("depr"),
	FIN("fin"),
	GER("ger"),
	IMPS("imps"),
	IMPT("impt"),
	INF("inf"),
	INTERP("interp"),
	NUM("num"),
	PREP("prep"),
	QUB("qub"),
	PACT("pact"),
	PANT("pant"),
	PCON("pcon"),
	PPAS("ppas"),
	PRED("pred"),
	PPRON12("ppron12"),
	PPRON3("ppron3"),
	PRAET("praet"),
	SIEBIE("siebie"),
	SUBST("subst"),
	ROOT("root"),
	VERB("verb"),
	WINIEN("winien"),
	NIL("nil");
	
	private String posName;
	
	private POS(String posName) {
		this.posName = posName;
	}
	
	public static POS makePOS(String posName) {
		for (POS p : POS.values()) {
			if (p.posName.contentEquals(posName)) {
				return p;
			}
		}
		System.out.println("unknown POS: " + posName);
		return POS.NIL;
	}
	
	public String getPOSname() {
		return this.posName;
	}

}
