package parser;

public enum SwigraTag {

	COND_AGLT("condaglt"),
	CUDZ("cudz"),
	FF("ff"),
	FL("fl"),
	FLICZ("flicz"),
	FNO("fno"),
	FPM("fpm"),
	FPMPT("fpmpt"),
	FPS("fps"),
	FPT("fpt"),
	FZ("fz"),
	FW("fw"),
	FWE("fwe"),
	FZD("fzd"),
	FORMA_CZAS("formaczas"),
	FORMA_LICZ("formalicz"),
	FORMA_PRZYM("formaprzym"),
	FORMA_PRZYS("formaprzys"),
	FORMA_RZECZ("formarzecz"),
	KORELAT("korelat"),
	MOD_JAKI("modjaki"),
	MOD_PART("modpart"),
	NAWIAS("nawias"),
	PARTYKULA("partykuła"),
	PAUZA("pauza"),
	POSILK("posiłk"),
	PRZEC("przec"),
	PRZYIMEK("przyimek"),
	PRZY_ZLO("przyzlo"),
	SPOJNIK("spójnik"),
	WYPOWIEDZENIE("wypowiedzenie"),
	ZAIM_OS("zaimos"),
	ZAIM_PRZYM("zaimprzym"),
	ZAIM_RZECZ("zaimrzecz"),
	ZDANIE("zdanie"),
	ZNAK_KONCA("znakkonca"),
	
	//do bedzie
	BEDZIE("bedzie"),
	//do aglt
	AGLT("aglt"),
	
	//zależnościowe
	ABBREV_PUNCT("abbrev_punct"),
	ADJUNCT("adjunct"),
	//aglt - już jest
	APP("app"),
	AUX("aux"),
	COMP("comp"),
	COMP_FIN("comp_fin"),
	COMP_INF("comp_inf"),
	COMPLM("complm"),
	COND("cond"),
	CONJUNCT("conjunct"),
	COORD("coord"),
	COORD_PUNCT("coord_punct"),
	IMP("imp"),
	MWE("mwe"),
	NEG("neg"),
	OBJ("obj"),
	OBJ_TH("obj_th"),
	PD("pd"),
	PRED("pred"),
	PRE_COORD("pre_coord"),
	PUNCT("punct"),
	REFL("refl"),
	ROOT("root"),
	SUBJ("subj"),
	SUBORD("subord"),
	
	NIL("nil"),
	LEAF("leaf");

	private String name;

	private SwigraTag(String name) {
		this.name = name;
	}

	public static SwigraTag makeTag(String name) {
		for (SwigraTag t : SwigraTag.values()) {
			if (t.name.contentEquals(name)) {
				return t;
			}
		}
		System.out.println("unknown tag: " + name);
		return SwigraTag.NIL;
		//throw new NullPointerException();
	}
	
	public String getTagname() {
		return this.name;
	}
	
}
