package parser;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

import trees.SwigraTreeNode;

public class SwigraTreeHandler extends DefaultHandler {

	public boolean success = false;
	private boolean chosen = false;
	private boolean chosenChildren = false;
	private boolean cat = false;
	private boolean orth = false;
	private boolean base = false;
	private boolean pos = false;
	private boolean fs;
	private Feature currF;
	private Integer currId;
	private SwigraTreeNode currNode;
	private Map<Integer, SwigraTreeNode> nodes = new HashMap<Integer, SwigraTreeNode>();
	private List<String> annotators = new LinkedList<String>();
	

	public Map<Integer, SwigraTreeNode> getNodes() {
		return this.nodes;
	}
	
	public List<String> getAnnotators() {
		return this.annotators;
	}
	
	@Override
	public void startElement(String uri, String localName, String qName,
			Attributes attrs) throws SAXException {
		if (qName.contentEquals("base-answer")
				&& attrs.getValue("type").contentEquals("FULL")) {
			this.success = true;
		} else if (!this.success) {
			return;
		} else if (qName.contentEquals("extra-answer")) {
			this.annotators.add(attrs.getValue("username"));
		} else if (qName.contentEquals("node")) {
			this.currId = Integer.parseInt(attrs.getValue("nid"));
			if (attrs.getValue("chosen").contentEquals("true")) {
				this.chosen = true;
				this.currNode = new SwigraTreeNode();
				this.currNode.id = this.currId;
				this.nodes.put(this.currId, this.currNode);
			}
		} else if (qName.contentEquals("children")) {
			this.chosenChildren = (attrs.getType("chosen") != null);
			if (this.chosenChildren) {
				this.currNode.rule = attrs.getValue("rule");
			}
		} else if (qName.contentEquals("child") && this.chosenChildren) {
			Integer childId = Integer.parseInt(attrs.getValue("nid"));
			this.currNode.addChild(childId);
			if (attrs.getValue("head").contentEquals("true")) {
				this.currNode.headChildren.add(childId);
			}
		}
		this.cat = qName.contentEquals("category");
		this.orth = qName.contentEquals("orth");
		this.base = qName.contentEquals("base");
		this.pos = (qName.contentEquals("f") && attrs.getValue("type").contentEquals("tag"));
		this.fs = qName.contentEquals("f");
		if (this.fs) {
			this.currF = Feature.makeFeature(attrs.getValue("type"));
		}
	}
	
	@Override
	public void endElement(String uri, String localName, String qName)
			throws SAXException {
		if (qName.contentEquals("node")) {
			this.chosen = false;
			this.chosenChildren = false;
		}
		this.cat = false;
		this.orth = false;
		this.base = false;
		this.pos = false;
		this.fs = false;
	}

	@Override
	public void characters(char[] ch, int start, int length)
			throws SAXException {
		if (this.cat && this.chosen) {
			this.currNode.tag = SwigraTag.makeTag(String.valueOf(ch, start, length));
		}
		if (this.orth && this.chosen) {
			this.currNode.orth = String.valueOf(ch, start, length);
		}
		if (this.base && this.chosen) {
			this.currNode.base = String.valueOf(ch, start, length);
		}
		if (this.pos && this.chosen) {
			this.currNode.pos = String.valueOf(ch, start, length);
		}
		if (this.fs && this.chosen) {
			if (this.currF == Feature.REKCJA && String.valueOf(ch, start, length).contentEquals("_")) {
				this.currNode.fs.put(this.currF, "_");
			} else if (this.currF == Feature.NEG && String.valueOf(ch, start, length).contentEquals("nie(_)")) {
				this.currNode.fs.put(this.currF, "nie");
		    } else if (!String.valueOf(ch, start, length).contentEquals("_")) {
				this.currNode.fs.put(this.currF, String.valueOf(ch, start, length));
			}
		}
	}

}