package tag;

import java.util.List;

import de.tuebingen.tokenizer.Word;
import de.tuebingen.tree.Grammar;
import de.tuebingen.ui.CommandLineOptions;

public class TulipaRunner implements Runnable {

	private CommandLineOptions ops;
	private Grammar g;
	private String s;
	private List<Word> tokens;
	public String logMsg = "";
	
	public TulipaRunner(CommandLineOptions ops, Grammar g, String s,
			List<Word> tokens) {
		super();
		this.ops = ops;
		this.g = g;
		this.s = s;
		this.tokens = tokens;
	}

	@Override
	public void run() {
		boolean success = false;
		try {
			success = AlternativeInterface.parseSentence(ops,
					g, s, tokens);
		} catch (Exception e) {
			success = false;
			e.printStackTrace();
			this.logMsg = "Caught exception when parsing: "
					+ e.toString() + "\n";
		} catch (OutOfMemoryError e) {
			success = false;
			e.printStackTrace();
			this.logMsg = "Out of memory when parsing: "
					+ e.toString() + "\n";
		}
		if (success) {
			this.logMsg += "SUCCESS !!!\n";
		} else {
			this.logMsg += "(no parse)\n";
		}
	}
	
}
