package tag.extract;

import parser.Feature;
import parser.SwigraTag;
import trees.TAGTreeNode;

public class AgltFromVerb extends AltTreeBuilder {

	@Override
	protected TAGTreeNode buildFormaczas(TAGTreeNode tree) {
		TAGTreeNode root = tree.nodeCopy();
		TAGTreeNode verb = tree.headChild.nodeCopy();
		verb.trunk = true;
		verb.fs.remove(Feature.OSOBA);
		root.children.add(verb);
		root.headChild = verb;
		
		TAGTreeNode aglt = new TAGTreeNode();
		aglt.subst = true;
		aglt.id = 101;
		aglt.tag = SwigraTag.AGLT;
		for (int i = 0; i < TAGTreeNode.grammarFeatures.length; ++i) {
			Feature f = TAGTreeNode.grammarFeatures[i];
			if ((f == Feature.LICZBA || f == Feature.OSOBA)
					&& root.fs.containsKey(f)) {
				aglt.fs.put(f, root.fs.get(f));
			}
		}
		root.children.add(aglt);
		return root;
	}

}
