package tag.extract;

import parser.Feature;
import parser.SwigraTag;
import trees.TAGTreeNode;

public abstract class AltTreeBuilder {
	
	public TAGTreeNode build(TAGTreeNode tree) {
		TAGTreeNode root = null;
		if (tree.tag != SwigraTag.FORMA_CZAS) {
			root = tree.nodeCopy();
			for (TAGTreeNode child : tree.children) {
				TAGTreeNode ch = this.build(child);
				if (ch == null) {
					return null;
				}
				root.children.add(ch);
				if (child.equals(tree.headChild)) {
					root.headChild = ch;
				}
			}
			root.footNode = tree.footNode;
		} else {
			root = this.buildFormaczas(tree);
		}
		return root;
	}
	
	protected abstract TAGTreeNode buildFormaczas(TAGTreeNode tree);

}
