package tag.extract;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import parser.Feature;
import utility.Utility;

import com.dawidweiss.morfeusz.InterpMorf;

public class MorphGenerator {

	public static List<String> getMorphEntries(InterpMorf i, Feature[] fs) {
		//System.out.println(i.getTagImage());
		Set<String> entries = new HashSet<String>();
		List<String> morphs = new LinkedList<String>();
		String[] ms = i.getTagImage().replace("|", "#").split("#");
		for (int j = 0; j < ms.length; ++j) {
			//System.out.print(ms[j] + " ");
			morphs.add(MorphGenerator.complete(ms[j]));
		}
		//System.out.println();
		int x = 0;
		while (x >= 0) {
			x = -1;
			for (int y = 0; y < morphs.size(); ++y) {
				if (morphs.get(y).contains(".")) {
					x = y;
					break;
				}
			}
			if (x >= 0) {
				String s = morphs.get(x);
				int dot = s.indexOf(".");
				int end = s.indexOf(":", dot);
				if (end < 0) {
					end = s.length();
				}
				int begin = s.lastIndexOf(":", dot);
				if (begin < 0) {
					begin = 0;
				}
				morphs.remove(x);
				morphs.add(s.substring(0, dot) + s.substring(end, s.length()));
				morphs.add(s.substring(0, begin + 1)
						+ s.substring(dot + 1, s.length()));
			}
		}
		for (String morph : morphs) {
			String m = MorphGenerator.convertMorph(morph, fs);
			if (m != null) {
				String entry = i.getTokenImage() + "    " + i.getLemmaImage()
						+ "    " + MorphGenerator.convertMorph(morph, fs);
				entries.add(entry);
			}
		}
		return new LinkedList<String>(entries);
	}
	
	private static void complete(String[] tags, Feature[] fs) {
		for (int i = 0; i < fs.length; ++i) {
			if (tags[i + 1].contentEquals("_")) {
				switch (fs[i]) {
				case LICZBA : {
					tags[i + 1] = "sg.pl";
					break;
				}
				case OSOBA : {
					tags[i + 1] = "pri.sec.ter";
					break;
				}
				case RODZAJ : {
					tags[i + 1] = "m1.m2.m3.f.n";
					break;
				}
				case PRZYPADEK : {
					tags[i + 1] = "nom.gen.dat.acc.inst.loc.voc";
					break;
				}
				default : {
					System.err.println(fs[i]);
					System.exit(1);
				}
				}
			}
		}
	}
	
	private static String complete(String morph) {
		String[] tags = morph.split(":");
		String pos = tags[0];
		Feature[] fs = {};
		if (pos.contentEquals("interp")) {
			// do nothing
		} else if (pos.contentEquals("subst") || pos.contentEquals("depr")
				|| pos.contentEquals("psubst")) {
			// liczba przypadek rodzaj
			Feature[] fs1 = { Feature.LICZBA, Feature.PRZYPADEK, Feature.RODZAJ };
			fs = fs1;
		} else if (pos.contentEquals("num") || pos.contentEquals("numcol")) {
			// liczba przypadek rodzaj akomod
			Feature[] fs1 = { Feature.LICZBA, Feature.PRZYPADEK, Feature.RODZAJ, Feature.AKOM };
			fs = fs1;
		} else if (pos.contentEquals("adj") || pos.contentEquals("padj")) {
			// liczba przypadek rodzaj stopien
			Feature[] fs1 = { Feature.LICZBA, Feature.PRZYPADEK, Feature.RODZAJ, Feature.STOPIEN };
			fs = fs1;
		} else if (pos.contentEquals("adja") || pos.contentEquals("adjp")
				|| pos.contentEquals("adjc") || pos.contentEquals("pred")
				|| pos.contentEquals("conj") || pos.contentEquals("comp")
				|| pos.contentEquals("qub")) {
			//
		} else if (pos.contentEquals("adv") || pos.contentEquals("padv")) {
			if (tags.length > 1) {
				Feature[] fs1 = { Feature.STOPIEN };
				fs = fs1;
			}
		} else if (pos.contentEquals("ppron12")) {
			// liczba przypadek rodzaj osoba akcent
			Feature[] fs1 = { Feature.LICZBA, Feature.PRZYPADEK, Feature.RODZAJ, Feature.OSOBA };
			fs = fs1;
		} else if (pos.contentEquals("ppron3")) {
			// liczba przypadek rodzaj osoba akcent poprzyim
			Feature[] fs1 = { Feature.LICZBA, Feature.PRZYPADEK, Feature.RODZAJ, Feature.OSOBA };
			fs = fs1;
		} else if (pos.contentEquals("siebie") || pos.contentEquals("prep")) {
			// przypadek
			Feature[] fs1 = { Feature.PRZYPADEK };
			fs = fs1;
		} else if (pos.contentEquals("fin")) {
			// liczba osoba aspekt
			Feature[] fs1 = { Feature.LICZBA, Feature.OSOBA, Feature.ASPEKT };
			fs = fs1;
		} else if (pos.contentEquals("bedzie")) {
			// liczba osoba aspekt
			Feature[] fs1 = { Feature.LICZBA, Feature.OSOBA, Feature.ASPEKT };
			fs = fs1;
		} else if (pos.contentEquals("aglt")) {
			// liczba osoba aspekt wokal
			Feature[] fs1 = { Feature.LICZBA, Feature.OSOBA, Feature.ASPEKT, Feature.WOKAL };
			fs = fs1;
		} else if (pos.contentEquals("praet")) {
			// liczba rodzaj aspekt aglutyn
			if (tags.length == 4) {
				Feature[] fs1 = { Feature.LICZBA, Feature.RODZAJ, Feature.ASPEKT };
				fs = fs1;
			} else {
				Feature[] fs1 = { Feature.LICZBA, Feature.RODZAJ, Feature.ASPEKT, Feature.AGLUTYN };
				fs = fs1;
			}
		} else if (pos.contentEquals("impt")) {
			// liczba osoba aspekt
			Feature[] fs1 = { Feature.LICZBA, Feature.OSOBA, Feature.ASPEKT };
			fs = fs1;
		} else if (pos.contentEquals("imps") || pos.contentEquals("inf")
				|| pos.contentEquals("pcon") || pos.contentEquals("pant")) {
			Feature[] fs1 = { Feature.ASPEKT };
			fs = fs1;
		} else if (pos.contentEquals("ger") || pos.contentEquals("pact")
				|| pos.contentEquals("ppas")) {
			// liczba przypadek rodzaj aspekt zaneg
			Feature[] fs1 = { Feature.LICZBA, Feature.PRZYPADEK, Feature.RODZAJ, Feature.ASPEKT, Feature.NEG };
			fs = fs1;
		} else if (pos.contentEquals("winien")) {
			// liczba rodzaj aspekt
			Feature[] fs1 = { Feature.LICZBA, Feature.RODZAJ, Feature.ASPEKT };
			fs = fs1;
		} else if (pos.contentEquals("brev")) {
			Feature[] fs1 = { Feature.KROPK };
			fs = fs1;
		}
		MorphGenerator.complete(tags, fs);
		return Utility.join(tags, ":");
	}

	public static String convertMorph(String morph, Feature[] fs) {
		String[] tags = morph.split(":");
		String pos = tags[0];
		//System.out.println(morph);
		// String m = "";
		Map<Feature, String> m = new HashMap<Feature, String>();
		if (pos.contentEquals("interp")) {
			return null;
		} else if (pos.contentEquals("subst") || pos.contentEquals("depr")
				|| pos.contentEquals("psubst")) {
			// liczba przypadek rodzaj
			m.put(Feature.LICZBA, MorphGenerator.translateTag(tags[1]));
			m.put(Feature.PRZYPADEK, MorphGenerator.translateTag(tags[2]));
			m.put(Feature.RODZAJ, MorphGenerator.translateTag(tags[3]));
			// dodajemy osobę!!!
			m.put(Feature.OSOBA, "3");
		} else if (pos.contentEquals("num") || pos.contentEquals("numcol")) {
			// liczba przypadek rodzaj akomod
			m.put(Feature.LICZBA, MorphGenerator.translateTag(tags[1]));
			m.put(Feature.PRZYPADEK, MorphGenerator.translateTag(tags[2]));
			m.put(Feature.RODZAJ, MorphGenerator.translateTag(tags[3]));
			m.put(Feature.AKOM, MorphGenerator.translateTag(tags[4]));
		} else if (pos.contentEquals("adj") || pos.contentEquals("padj")) {
			// liczba przypadek rodzaj stopien
			m.put(Feature.LICZBA, MorphGenerator.translateTag(tags[1]));
			m.put(Feature.PRZYPADEK, MorphGenerator.translateTag(tags[2]));
			m.put(Feature.RODZAJ, MorphGenerator.translateTag(tags[3]));
			m.put(Feature.STOPIEN, MorphGenerator.translateTag(tags[4]));
		} else if (pos.contentEquals("adja") || pos.contentEquals("adjp")
				|| pos.contentEquals("adjc") || pos.contentEquals("pred")
				|| pos.contentEquals("conj") || pos.contentEquals("comp")
				|| pos.contentEquals("qub")) {
			//
		} else if (pos.contentEquals("adv") || pos.contentEquals("padv")) {
			if (tags.length > 1) {
				m.put(Feature.STOPIEN, MorphGenerator.translateTag(tags[1]));
			}
		} else if (pos.contentEquals("ppron12")) {
			// liczba przypadek rodzaj osoba akcent
			m.put(Feature.LICZBA, MorphGenerator.translateTag(tags[1]));
			m.put(Feature.PRZYPADEK, MorphGenerator.translateTag(tags[2]));
			m.put(Feature.RODZAJ, MorphGenerator.translateTag(tags[3]));
			m.put(Feature.OSOBA, MorphGenerator.translateTag(tags[4]));
			// m.put(Feature.AKCENT, MorphGenerator.translateTag(tags[5]));
		} else if (pos.contentEquals("ppron3")) {
			// liczba przypadek rodzaj osoba akcent poprzyim
			m.put(Feature.LICZBA, MorphGenerator.translateTag(tags[1]));
			m.put(Feature.PRZYPADEK, MorphGenerator.translateTag(tags[2]));
			m.put(Feature.RODZAJ, MorphGenerator.translateTag(tags[3]));
			m.put(Feature.OSOBA, MorphGenerator.translateTag(tags[4]));
			// m.put(Feature.AKCENT, MorphGenerator.translateTag(tags[5]));
			// m.put(Feature.POPRZYIMK, MorphGenerator.translateTag(tags[6]));
		} else if (pos.contentEquals("siebie") || pos.contentEquals("prep")) {
			// przypadek
			m.put(Feature.PRZYPADEK, MorphGenerator.translateTag(tags[1]));
		} else if (pos.contentEquals("fin")) {
			// liczba osoba aspekt
			// dodajemy czas!!!
			m.put(Feature.LICZBA, MorphGenerator.translateTag(tags[1]));
			m.put(Feature.OSOBA, MorphGenerator.translateTag(tags[2]));
			m.put(Feature.ASPEKT, MorphGenerator.translateTag(tags[3]));
			if (tags[1].contentEquals("perf")) {
				m.put(Feature.CZAS, "przy");
			} else {
				m.put(Feature.CZAS, "ter");
			}
		} else if (pos.contentEquals("bedzie")) {
			// liczba osoba aspekt
			// dodajemy czas!!!
			m.put(Feature.LICZBA, MorphGenerator.translateTag(tags[1]));
			m.put(Feature.OSOBA, MorphGenerator.translateTag(tags[2]));
			m.put(Feature.ASPEKT, MorphGenerator.translateTag(tags[3]));
			m.put(Feature.CZAS, "przy");
		} else if (pos.contentEquals("aglt")) {
			// liczba osoba aspekt wokal
			m.put(Feature.LICZBA, MorphGenerator.translateTag(tags[1]));
			m.put(Feature.OSOBA, MorphGenerator.translateTag(tags[2]));
			m.put(Feature.ASPEKT, MorphGenerator.translateTag(tags[3]));
			m.put(Feature.WOKAL, MorphGenerator.translateTag(tags[4]));
		} else if (pos.contentEquals("praet")) {
			// liczba rodzaj aspekt aglutyn
			// dodajemy czas!!!
			// dodajemy osobę!!!
			m.put(Feature.LICZBA, MorphGenerator.translateTag(tags[1]));
			m.put(Feature.RODZAJ, MorphGenerator.translateTag(tags[2]));
			m.put(Feature.ASPEKT, MorphGenerator.translateTag(tags[3]));
			if (tags.length > 4) {
				m.put(Feature.AGLUTYN, MorphGenerator.translateTag(tags[4]));
			}
			m.put(Feature.CZAS, "prze");
			m.put(Feature.OSOBA, "3");
		} else if (pos.contentEquals("impt")) {
			// liczba osoba aspekt
			m.put(Feature.LICZBA, MorphGenerator.translateTag(tags[1]));
			m.put(Feature.OSOBA, MorphGenerator.translateTag(tags[2]));
			m.put(Feature.ASPEKT, MorphGenerator.translateTag(tags[3]));
		} else if (pos.contentEquals("imps") || pos.contentEquals("inf")
				|| pos.contentEquals("pcon") || pos.contentEquals("pant")) {
			m.put(Feature.ASPEKT, MorphGenerator.translateTag(tags[1]));
		} else if (pos.contentEquals("ger") || pos.contentEquals("pact")
				|| pos.contentEquals("ppas")) {
			// liczba przypadek rodzaj aspekt zaneg
			m.put(Feature.LICZBA, MorphGenerator.translateTag(tags[1]));
			m.put(Feature.PRZYPADEK, MorphGenerator.translateTag(tags[2]));
			m.put(Feature.RODZAJ, MorphGenerator.translateTag(tags[3]));
			m.put(Feature.ASPEKT, MorphGenerator.translateTag(tags[4]));
			m.put(Feature.NEG, MorphGenerator.translateTag(tags[5]));
		} else if (pos.contentEquals("winien")) {
			// liczba rodzaj aspekt
			m.put(Feature.LICZBA, MorphGenerator.translateTag(tags[1]));
			m.put(Feature.RODZAJ, MorphGenerator.translateTag(tags[2]));
			m.put(Feature.ASPEKT, MorphGenerator.translateTag(tags[3]));
		} else if (pos.contentEquals("brev")) {
			m.put(Feature.KROPK, MorphGenerator.translateTag(tags[1]));
		}
		StringBuilder ret = new StringBuilder();
		ret.append("    [pos = ");
		if (pos.contentEquals("fin") || pos.contentEquals("praet")) {
			pos = "verb";
		}
		ret.append(pos);
		for (int i = 0; i < fs.length; ++i) {
			Feature f = fs[i];
			if (f != Feature.POS && m.containsKey(f)) {
				ret.append("; ");
				ret.append(Utility.toAscii(f.getFname()));
				ret.append(" = ");
				ret.append(m.get(f));
			}
		}
		ret.append(" ]");
		return ret.toString();
	}

	private static String translateTag(String tag) {
		// n1, n2, p1, p2, p3 -> nij
		if (tag.contentEquals("sg")) {
			return "poj";
		} else if (tag.contentEquals("pl")) {
			return "mno";
		} else if (tag.contentEquals("nom")) {
			return "mian";
		} else if (tag.contentEquals("gen")) {
			return "dop";
		} else if (tag.contentEquals("dat")) {
			return "cel";
		} else if (tag.contentEquals("acc")) {
			return "bier";
		} else if (tag.contentEquals("loc")) {
			return "miej";
		} else if (tag.contentEquals("inst")) {
			return "narz";
		} else if (tag.contentEquals("voc")) {
			return "wol";
		} else if (tag.contentEquals("m1")) {
			return "mos";
		} else if (tag.contentEquals("m2")) {
			return "mzw";
		} else if (tag.contentEquals("m3")) {
			return "mnz";
		} else if (tag.contentEquals("p1")) {
			return "nij";
		} else if (tag.contentEquals("p2")) {
			return "nij";
		} else if (tag.contentEquals("p3")) {
			return "nij";
		} else if (tag.contentEquals("n1")) {
			return "nij";
		} else if (tag.contentEquals("n2")) {
			return "nij";
		} else if (tag.contentEquals("f")) {
			return "zen";
		} else if (tag.contentEquals("n")) {
			return "nij";
		} else if (tag.contentEquals("pri")) {
			return "1";
		} else if (tag.contentEquals("sec")) {
			return "2";
		} else if (tag.contentEquals("ter")) {
			return "3";
		} else if (tag.contentEquals("pos")) {
			return "row";
		} else if (tag.contentEquals("com")) {
			return "wyz";
		} else if (tag.contentEquals("sup")) {
			return "naj";
		} else if (tag.contentEquals("imperf")) {
			return "ndk";
		} else if (tag.contentEquals("perf")) {
			return "dk";
		} else if (tag.contentEquals("aff")) {
			return "nie";
		} else if (tag.contentEquals("neg")) {
			return "tak";
		} else if (tag.contentEquals("congr")) {
			return "uzg";
		} else if (tag.contentEquals("rec")) {
			return "nuzg";
		} else if (tag.contentEquals("wok")) {
			return "wok";
		} else if (tag.contentEquals("nwok")) {
			return "nwok";
		} else if (tag.contentEquals("pun")) {
			return "pun";
		} else if (tag.contentEquals("npun")) {
			return "npun";
		} else if (tag.contentEquals("nagl")) {
			return "nagl";
		} else if (tag.contentEquals("agl")) {
			return "agl";
		}
		System.err.println("Unknown tag: " + tag);
		System.exit(1);
		return null;
	}
}